<?xml version="1.0" encoding="UTF-8"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:MTR="http://www.govtalk.gov.uk/taxation/SA/SA100/15-16/1" xmlns:dsig="http://www.w3.org/2000/09/xmldsig#" xmlns:hd="http://www.govtalk.gov.uk/CM/envelope" xmlns:date="http://exslt.org/dates-and-times" xmlns:dyn="http://exslt.org/dynamic" xmlns:exsl="http://exslt.org/common" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:math="http://exslt.org/math" xmlns:random="http://exslt.org/random" xmlns:regexp="http://exslt.org/regular-expressions" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:set="http://exslt.org/sets" xmlns:str="http://exslt.org/strings" MTR:dummy-for-xmlns="" dsig:dummy-for-xmlns="" exclude-result-prefixes="sch iso" extension-element-prefixes="date dyn math random regexp set str exsl" hd:dummy-for-xmlns="" version="1.0">

<!--PHASES-->


<!--PROLOG-->
<dsl-rim:namespaceMappings xmlns:dsl-rim="http://www.decisionsoft.com/rim" xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse">
    <dsl-rim:namespaceMapping prefix="hd" uri="http://www.govtalk.gov.uk/CM/envelope"/>
    <dsl-rim:namespaceMapping prefix="dsig" uri="http://www.w3.org/2000/09/xmldsig#"/>
    <dsl-rim:namespaceMapping prefix="MTR" uri="http://www.govtalk.gov.uk/taxation/SA/SA100/15-16/1"/>
  </dsl-rim:namespaceMappings>
  <axsl:output xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" indent="yes" method="xml" omit-xml-declaration="no" standalone="yes"/>

<!--KEYS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-FULL-PATH-->
<axsl:template match="*" mode="schematron-get-full-path">
    <axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
    <axsl:text>/</axsl:text>
    <axsl:variable name="nsuri" select="namespace-uri()"/>
    <axsl:variable xmlns:dsl-rim="http://www.decisionsoft.com/rim" name="prefix" select="document('')//dsl-rim:namespaceMapping[@uri=$nsuri]/@prefix"/>
    <axsl:if test="$prefix">
      <axsl:value-of select="concat($prefix,':')"/>
    </axsl:if>
    <axsl:value-of select="local-name()"/>
    <axsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
    <axsl:text>[</axsl:text>
    <axsl:value-of select="1+ $preceding"/>
    <axsl:text>]</axsl:text>
  </axsl:template>
  <axsl:template match="@*" mode="schematron-get-full-path">
    <axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
    <axsl:text>/@</axsl:text>
    <axsl:variable name="nsuri" select="namespace-uri()"/>
    <axsl:variable xmlns:dsl-rim="http://www.decisionsoft.com/rim" name="prefix" select="document('')//dsl-rim:namespaceMapping[@uri=$nsuri]/@prefix"/>
    <axsl:if test="$prefix">
      <axsl:value-of select="concat($prefix,':')"/>
    </axsl:if>
    <axsl:value-of select="local-name()"/>
  </axsl:template>
  <!--Strip characters-->
  <axsl:template match="text()" priority="-1"/>

<!--SCHEMA METADATA-->
<axsl:template match="/">
    <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errors">
      <axsl:apply-templates mode="M4" select="/"/>
      <axsl:apply-templates mode="M5" select="/"/>
      <axsl:apply-templates mode="M6" select="/"/>
      <axsl:apply-templates mode="M7" select="/"/>
      <axsl:apply-templates mode="M8" select="/"/>
      <axsl:apply-templates mode="M9" select="/"/>
      <axsl:apply-templates mode="M10" select="/"/>
      <axsl:apply-templates mode="M11" select="/"/>
      <axsl:apply-templates mode="M12" select="/"/>
      <axsl:apply-templates mode="M13" select="/"/>
      <axsl:apply-templates mode="M14" select="/"/>
      <axsl:apply-templates mode="M15" select="/"/>
      <axsl:apply-templates mode="M16" select="/"/>
      <axsl:apply-templates mode="M17" select="/"/>
      <axsl:apply-templates mode="M18" select="/"/>
      <axsl:apply-templates mode="M19" select="/"/>
      <axsl:apply-templates mode="M20" select="/"/>
      <axsl:apply-templates mode="M21" select="/"/>
      <axsl:apply-templates mode="M22" select="/"/>
      <axsl:apply-templates mode="M23" select="/"/>
      <axsl:apply-templates mode="M24" select="/"/>
      <axsl:apply-templates mode="M25" select="/"/>
      <axsl:apply-templates mode="M26" select="/"/>
      <axsl:apply-templates mode="M27" select="/"/>
      <axsl:apply-templates mode="M28" select="/"/>
      <axsl:apply-templates mode="M29" select="/"/>
      <axsl:apply-templates mode="M30" select="/"/>
      <axsl:apply-templates mode="M31" select="/"/>
      <axsl:apply-templates mode="M32" select="/"/>
      <axsl:apply-templates mode="M33" select="/"/>
      <axsl:apply-templates mode="M34" select="/"/>
      <axsl:apply-templates mode="M35" select="/"/>
      <axsl:apply-templates mode="M36" select="/"/>
      <axsl:apply-templates mode="M37" select="/"/>
      <axsl:apply-templates mode="M38" select="/"/>
      <axsl:apply-templates mode="M39" select="/"/>
      <axsl:apply-templates mode="M40" select="/"/>
      <axsl:apply-templates mode="M41" select="/"/>
      <axsl:apply-templates mode="M42" select="/"/>
      <axsl:apply-templates mode="M43" select="/"/>
      <axsl:apply-templates mode="M44" select="/"/>
      <axsl:apply-templates mode="M45" select="/"/>
      <axsl:apply-templates mode="M46" select="/"/>
      <axsl:apply-templates mode="M47" select="/"/>
      <axsl:apply-templates mode="M48" select="/"/>
      <axsl:apply-templates mode="M49" select="/"/>
      <axsl:apply-templates mode="M50" select="/"/>
      <axsl:apply-templates mode="M51" select="/"/>
      <axsl:apply-templates mode="M52" select="/"/>
      <axsl:apply-templates mode="M53" select="/"/>
      <axsl:apply-templates mode="M54" select="/"/>
      <axsl:apply-templates mode="M55" select="/"/>
      <axsl:apply-templates mode="M56" select="/"/>
      <axsl:apply-templates mode="M57" select="/"/>
      <axsl:apply-templates mode="M58" select="/"/>
      <axsl:apply-templates mode="M59" select="/"/>
      <axsl:apply-templates mode="M60" select="/"/>
      <axsl:apply-templates mode="M61" select="/"/>
      <axsl:apply-templates mode="M62" select="/"/>
      <axsl:apply-templates mode="M63" select="/"/>
      <axsl:apply-templates mode="M64" select="/"/>
      <axsl:apply-templates mode="M65" select="/"/>
      <axsl:apply-templates mode="M66" select="/"/>
      <axsl:apply-templates mode="M67" select="/"/>
      <axsl:apply-templates mode="M68" select="/"/>
      <axsl:apply-templates mode="M69" select="/"/>
      <axsl:apply-templates mode="M70" select="/"/>
      <axsl:apply-templates mode="M71" select="/"/>
      <axsl:apply-templates mode="M72" select="/"/>
      <axsl:apply-templates mode="M73" select="/"/>
      <axsl:apply-templates mode="M74" select="/"/>
      <axsl:apply-templates mode="M75" select="/"/>
      <axsl:apply-templates mode="M76" select="/"/>
      <axsl:apply-templates mode="M77" select="/"/>
      <axsl:apply-templates mode="M78" select="/"/>
      <axsl:apply-templates mode="M79" select="/"/>
      <axsl:apply-templates mode="M80" select="/"/>
      <axsl:apply-templates mode="M81" select="/"/>
      <axsl:apply-templates mode="M82" select="/"/>
      <axsl:apply-templates mode="M83" select="/"/>
      <axsl:apply-templates mode="M84" select="/"/>
      <axsl:apply-templates mode="M85" select="/"/>
      <axsl:apply-templates mode="M86" select="/"/>
      <axsl:apply-templates mode="M87" select="/"/>
      <axsl:apply-templates mode="M88" select="/"/>
      <axsl:apply-templates mode="M89" select="/"/>
      <axsl:apply-templates mode="M90" select="/"/>
      <axsl:apply-templates mode="M91" select="/"/>
      <axsl:apply-templates mode="M92" select="/"/>
      <axsl:apply-templates mode="M93" select="/"/>
      <axsl:apply-templates mode="M94" select="/"/>
      <axsl:apply-templates mode="M95" select="/"/>
      <axsl:apply-templates mode="M96" select="/"/>
      <axsl:apply-templates mode="M97" select="/"/>
      <axsl:apply-templates mode="M98" select="/"/>
      <axsl:apply-templates mode="M99" select="/"/>
      <axsl:apply-templates mode="M100" select="/"/>
      <axsl:apply-templates mode="M101" select="/"/>
      <axsl:apply-templates mode="M102" select="/"/>
      <axsl:apply-templates mode="M103" select="/"/>
      <axsl:apply-templates mode="M104" select="/"/>
      <axsl:apply-templates mode="M105" select="/"/>
      <axsl:apply-templates mode="M106" select="/"/>
      <axsl:apply-templates mode="M107" select="/"/>
      <axsl:apply-templates mode="M108" select="/"/>
      <axsl:apply-templates mode="M109" select="/"/>
      <axsl:apply-templates mode="M110" select="/"/>
      <axsl:apply-templates mode="M111" select="/"/>
      <axsl:apply-templates mode="M112" select="/"/>
      <axsl:apply-templates mode="M113" select="/"/>
      <axsl:apply-templates mode="M114" select="/"/>
      <axsl:apply-templates mode="M115" select="/"/>
      <axsl:apply-templates mode="M116" select="/"/>
      <axsl:apply-templates mode="M117" select="/"/>
      <axsl:apply-templates mode="M118" select="/"/>
      <axsl:apply-templates mode="M119" select="/"/>
      <axsl:apply-templates mode="M120" select="/"/>
      <axsl:apply-templates mode="M121" select="/"/>
      <axsl:apply-templates mode="M122" select="/"/>
      <axsl:apply-templates mode="M123" select="/"/>
      <axsl:apply-templates mode="M124" select="/"/>
      <axsl:apply-templates mode="M125" select="/"/>
      <axsl:apply-templates mode="M126" select="/"/>
      <axsl:apply-templates mode="M127" select="/"/>
      <axsl:apply-templates mode="M128" select="/"/>
      <axsl:apply-templates mode="M129" select="/"/>
      <axsl:apply-templates mode="M130" select="/"/>
      <axsl:apply-templates mode="M131" select="/"/>
      <axsl:apply-templates mode="M132" select="/"/>
      <axsl:apply-templates mode="M133" select="/"/>
      <axsl:apply-templates mode="M134" select="/"/>
      <axsl:apply-templates mode="M135" select="/"/>
      <axsl:apply-templates mode="M136" select="/"/>
      <axsl:apply-templates mode="M137" select="/"/>
      <axsl:apply-templates mode="M138" select="/"/>
      <axsl:apply-templates mode="M139" select="/"/>
      <axsl:apply-templates mode="M140" select="/"/>
      <axsl:apply-templates mode="M141" select="/"/>
      <axsl:apply-templates mode="M142" select="/"/>
      <axsl:apply-templates mode="M143" select="/"/>
      <axsl:apply-templates mode="M144" select="/"/>
      <axsl:apply-templates mode="M145" select="/"/>
      <axsl:apply-templates mode="M146" select="/"/>
      <axsl:apply-templates mode="M147" select="/"/>
      <axsl:apply-templates mode="M148" select="/"/>
      <axsl:apply-templates mode="M149" select="/"/>
      <axsl:apply-templates mode="M150" select="/"/>
      <axsl:apply-templates mode="M151" select="/"/>
      <axsl:apply-templates mode="M152" select="/"/>
      <axsl:apply-templates mode="M153" select="/"/>
      <axsl:apply-templates mode="M154" select="/"/>
      <axsl:apply-templates mode="M155" select="/"/>
      <axsl:apply-templates mode="M156" select="/"/>
      <axsl:apply-templates mode="M157" select="/"/>
      <axsl:apply-templates mode="M158" select="/"/>
      <axsl:apply-templates mode="M159" select="/"/>
      <axsl:apply-templates mode="M160" select="/"/>
      <axsl:apply-templates mode="M161" select="/"/>
      <axsl:apply-templates mode="M162" select="/"/>
      <axsl:apply-templates mode="M163" select="/"/>
      <axsl:apply-templates mode="M164" select="/"/>
      <axsl:apply-templates mode="M165" select="/"/>
      <axsl:apply-templates mode="M166" select="/"/>
      <axsl:apply-templates mode="M167" select="/"/>
      <axsl:apply-templates mode="M168" select="/"/>
      <axsl:apply-templates mode="M169" select="/"/>
      <axsl:apply-templates mode="M170" select="/"/>
      <axsl:apply-templates mode="M171" select="/"/>
      <axsl:apply-templates mode="M172" select="/"/>
      <axsl:apply-templates mode="M173" select="/"/>
      <axsl:apply-templates mode="M174" select="/"/>
      <axsl:apply-templates mode="M175" select="/"/>
      <axsl:apply-templates mode="M176" select="/"/>
      <axsl:apply-templates mode="M177" select="/"/>
      <axsl:apply-templates mode="M178" select="/"/>
      <axsl:apply-templates mode="M179" select="/"/>
      <axsl:apply-templates mode="M180" select="/"/>
      <axsl:apply-templates mode="M181" select="/"/>
      <axsl:apply-templates mode="M182" select="/"/>
      <axsl:apply-templates mode="M183" select="/"/>
      <axsl:apply-templates mode="M184" select="/"/>
      <axsl:apply-templates mode="M185" select="/"/>
      <axsl:apply-templates mode="M186" select="/"/>
      <axsl:apply-templates mode="M187" select="/"/>
      <axsl:apply-templates mode="M188" select="/"/>
      <axsl:apply-templates mode="M189" select="/"/>
      <axsl:apply-templates mode="M190" select="/"/>
      <axsl:apply-templates mode="M191" select="/"/>
      <axsl:apply-templates mode="M192" select="/"/>
      <axsl:apply-templates mode="M193" select="/"/>
      <axsl:apply-templates mode="M194" select="/"/>
      <axsl:apply-templates mode="M195" select="/"/>
      <axsl:apply-templates mode="M196" select="/"/>
      <axsl:apply-templates mode="M197" select="/"/>
      <axsl:apply-templates mode="M198" select="/"/>
      <axsl:apply-templates mode="M199" select="/"/>
      <axsl:apply-templates mode="M200" select="/"/>
      <axsl:apply-templates mode="M201" select="/"/>
      <axsl:apply-templates mode="M202" select="/"/>
      <axsl:apply-templates mode="M203" select="/"/>
      <axsl:apply-templates mode="M204" select="/"/>
      <axsl:apply-templates mode="M205" select="/"/>
      <axsl:apply-templates mode="M206" select="/"/>
      <axsl:apply-templates mode="M207" select="/"/>
      <axsl:apply-templates mode="M208" select="/"/>
      <axsl:apply-templates mode="M209" select="/"/>
      <axsl:apply-templates mode="M210" select="/"/>
      <axsl:apply-templates mode="M211" select="/"/>
      <axsl:apply-templates mode="M212" select="/"/>
      <axsl:apply-templates mode="M213" select="/"/>
      <axsl:apply-templates mode="M214" select="/"/>
      <axsl:apply-templates mode="M215" select="/"/>
      <axsl:apply-templates mode="M216" select="/"/>
      <axsl:apply-templates mode="M217" select="/"/>
      <axsl:apply-templates mode="M218" select="/"/>
      <axsl:apply-templates mode="M219" select="/"/>
      <axsl:apply-templates mode="M220" select="/"/>
      <axsl:apply-templates mode="M221" select="/"/>
      <axsl:apply-templates mode="M222" select="/"/>
      <axsl:apply-templates mode="M223" select="/"/>
      <axsl:apply-templates mode="M224" select="/"/>
      <axsl:apply-templates mode="M225" select="/"/>
      <axsl:apply-templates mode="M226" select="/"/>
      <axsl:apply-templates mode="M227" select="/"/>
      <axsl:apply-templates mode="M228" select="/"/>
      <axsl:apply-templates mode="M229" select="/"/>
      <axsl:apply-templates mode="M230" select="/"/>
      <axsl:apply-templates mode="M231" select="/"/>
      <axsl:apply-templates mode="M232" select="/"/>
      <axsl:apply-templates mode="M233" select="/"/>
      <axsl:apply-templates mode="M234" select="/"/>
      <axsl:apply-templates mode="M235" select="/"/>
      <axsl:apply-templates mode="M236" select="/"/>
      <axsl:apply-templates mode="M237" select="/"/>
      <axsl:apply-templates mode="M238" select="/"/>
      <axsl:apply-templates mode="M239" select="/"/>
      <axsl:apply-templates mode="M240" select="/"/>
      <axsl:apply-templates mode="M241" select="/"/>
      <axsl:apply-templates mode="M242" select="/"/>
      <axsl:apply-templates mode="M243" select="/"/>
      <axsl:apply-templates mode="M244" select="/"/>
      <axsl:apply-templates mode="M245" select="/"/>
      <axsl:apply-templates mode="M246" select="/"/>
      <axsl:apply-templates mode="M247" select="/"/>
      <axsl:apply-templates mode="M248" select="/"/>
      <axsl:apply-templates mode="M249" select="/"/>
      <axsl:apply-templates mode="M250" select="/"/>
      <axsl:apply-templates mode="M251" select="/"/>
      <axsl:apply-templates mode="M252" select="/"/>
      <axsl:apply-templates mode="M253" select="/"/>
      <axsl:apply-templates mode="M254" select="/"/>
      <axsl:apply-templates mode="M255" select="/"/>
      <axsl:apply-templates mode="M256" select="/"/>
      <axsl:apply-templates mode="M257" select="/"/>
      <axsl:apply-templates mode="M258" select="/"/>
      <axsl:apply-templates mode="M259" select="/"/>
      <axsl:apply-templates mode="M260" select="/"/>
      <axsl:apply-templates mode="M261" select="/"/>
      <axsl:apply-templates mode="M262" select="/"/>
      <axsl:apply-templates mode="M263" select="/"/>
      <axsl:apply-templates mode="M264" select="/"/>
      <axsl:apply-templates mode="M265" select="/"/>
      <axsl:apply-templates mode="M266" select="/"/>
      <axsl:apply-templates mode="M267" select="/"/>
      <axsl:apply-templates mode="M268" select="/"/>
      <axsl:apply-templates mode="M269" select="/"/>
      <axsl:apply-templates mode="M270" select="/"/>
      <axsl:apply-templates mode="M271" select="/"/>
      <axsl:apply-templates mode="M272" select="/"/>
      <axsl:apply-templates mode="M273" select="/"/>
      <axsl:apply-templates mode="M274" select="/"/>
      <axsl:apply-templates mode="M275" select="/"/>
      <axsl:apply-templates mode="M276" select="/"/>
      <axsl:apply-templates mode="M277" select="/"/>
      <axsl:apply-templates mode="M278" select="/"/>
      <axsl:apply-templates mode="M279" select="/"/>
      <axsl:apply-templates mode="M280" select="/"/>
      <axsl:apply-templates mode="M281" select="/"/>
      <axsl:apply-templates mode="M282" select="/"/>
      <axsl:apply-templates mode="M283" select="/"/>
      <axsl:apply-templates mode="M284" select="/"/>
      <axsl:apply-templates mode="M285" select="/"/>
      <axsl:apply-templates mode="M286" select="/"/>
      <axsl:apply-templates mode="M287" select="/"/>
      <axsl:apply-templates mode="M288" select="/"/>
      <axsl:apply-templates mode="M289" select="/"/>
      <axsl:apply-templates mode="M290" select="/"/>
      <axsl:apply-templates mode="M291" select="/"/>
      <axsl:apply-templates mode="M292" select="/"/>
      <axsl:apply-templates mode="M293" select="/"/>
      <axsl:apply-templates mode="M294" select="/"/>
      <axsl:apply-templates mode="M295" select="/"/>
      <axsl:apply-templates mode="M296" select="/"/>
      <axsl:apply-templates mode="M297" select="/"/>
      <axsl:apply-templates mode="M298" select="/"/>
      <axsl:apply-templates mode="M299" select="/"/>
      <axsl:apply-templates mode="M300" select="/"/>
      <axsl:apply-templates mode="M301" select="/"/>
      <axsl:apply-templates mode="M302" select="/"/>
      <axsl:apply-templates mode="M303" select="/"/>
      <axsl:apply-templates mode="M304" select="/"/>
      <axsl:apply-templates mode="M305" select="/"/>
      <axsl:apply-templates mode="M306" select="/"/>
      <axsl:apply-templates mode="M307" select="/"/>
      <axsl:apply-templates mode="M308" select="/"/>
      <axsl:apply-templates mode="M309" select="/"/>
      <axsl:apply-templates mode="M310" select="/"/>
      <axsl:apply-templates mode="M311" select="/"/>
      <axsl:apply-templates mode="M312" select="/"/>
      <axsl:apply-templates mode="M313" select="/"/>
      <axsl:apply-templates mode="M314" select="/"/>
      <axsl:apply-templates mode="M315" select="/"/>
      <axsl:apply-templates mode="M316" select="/"/>
      <axsl:apply-templates mode="M317" select="/"/>
      <axsl:apply-templates mode="M318" select="/"/>
      <axsl:apply-templates mode="M319" select="/"/>
      <axsl:apply-templates mode="M320" select="/"/>
      <axsl:apply-templates mode="M321" select="/"/>
      <axsl:apply-templates mode="M322" select="/"/>
      <axsl:apply-templates mode="M323" select="/"/>
      <axsl:apply-templates mode="M324" select="/"/>
      <axsl:apply-templates mode="M325" select="/"/>
      <axsl:apply-templates mode="M326" select="/"/>
    </axsl:variable>
    <err:ErrorResponse xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension" SchemaVersion="2.0">
      <axsl:copy-of select="$errors"/>
    </err:ErrorResponse>
  </axsl:template>

<!--SCHEMATRON PATTERNS-->


<!--PATTERN p2-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:IRheader/MTR:Keys/MTR:Key" mode="M4" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../../../hd:GovTalkDetails/hd:Keys/hd:Key[@Type = current()/@Type and . = current()]) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">5005</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Keys in the GovTalkDetails do not match those in the IRheader.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Keys in the IR header must also exist in the GovTalk header with the same value</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M4" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M4" priority="-1"/>
  <axsl:template match="@*|node()" mode="M4" priority="-2">
    <axsl:apply-templates mode="M4" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p1-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:IRheader" mode="M5" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(MTR:Keys/MTR:Key) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">5004</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">At least one key must exist in the IRheader</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>At least one key must exist in the IRheader</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M5" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M5" priority="-1"/>
  <axsl:template match="@*|node()" mode="M5" priority="-2">
    <axsl:apply-templates mode="M5" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p5-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth" mode="M6" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(&quot;2016-04-05&quot;)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6428</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Date of birth cannot be later than 5 April of the year of the return. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[YPD1] must be on or before the end of the return year.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M6" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M6" priority="-1"/>
  <axsl:template match="@*|node()" mode="M6" priority="-2">
    <axsl:apply-templates mode="M6" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p6-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourPersonalDetails/MTR:NewAddress/MTR:AddressLine4" mode="M7" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AddressLine1 and ../MTR:AddressLine2 and ../MTR:AddressLine3"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6509</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[A14] is completed, [A11], [A12] and [A13] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [A14] present then [A11], [A12] and [A13] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M7" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M7" priority="-1"/>
  <axsl:template match="@*|node()" mode="M7" priority="-2">
    <axsl:apply-templates mode="M7" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p7-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourPersonalDetails/MTR:NewAddress/MTR:EffectiveFrom" mode="M8" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(date:date())) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8325</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in [YPD2] must be on or before today. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[YPD2] must be on or before the current date.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M8" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M8" priority="-1"/>
  <axsl:template match="@*|node()" mode="M8" priority="-2">
    <axsl:apply-templates mode="M8" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p8-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:EmploymentSchedule" mode="M9" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfEmploymentSchedules"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6554</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [YTR1.1A]. Please complete box [YTR1.1B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [YTR1.1A] is present, [YTR1.1B] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M9" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M9" priority="-1"/>
  <axsl:template match="@*|node()" mode="M9" priority="-2">
    <axsl:apply-templates mode="M9" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p9-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:FullSelfEmploymentSchedule" mode="M10" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfFullSelfEmploymentSchedules"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6555</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [YTR2.2A]. Please complete box [YTR2.2B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Number of full self employment schedules should be present if [YTR2.2A]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M10" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M10" priority="-1"/>
  <axsl:template match="@*|node()" mode="M10" priority="-2">
    <axsl:apply-templates mode="M10" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p10-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:ShortSelfEmploymentSchedule" mode="M11" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfShortSelfEmploymentSchedules"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6556</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [YTR2A.2A]. Please complete box [YTR2A.2B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [YTR2A.2A] present then [YTR2A.2B] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M11" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M11" priority="-1"/>
  <axsl:template match="@*|node()" mode="M11" priority="-2">
    <axsl:apply-templates mode="M11" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p11-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:FullPartnershipSchedule" mode="M12" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfFullPartnershipSchedules"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6557</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [YTR3.3A]. Please complete box [YTR3.3B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Number of full partnership schedules should be present if [YTR3.3A]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M12" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M12" priority="-1"/>
  <axsl:template match="@*|node()" mode="M12" priority="-2">
    <axsl:apply-templates mode="M12" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p12-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:ShortPartnershipSchedule" mode="M13" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfShortPartnershipSchedules"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6558</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [YTR3A.3A]. Please complete box [YTR3A.3B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [YTR3A.3A] present then [YTR3A.3B] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M13" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M13" priority="-1"/>
  <axsl:template match="@*|node()" mode="M13" priority="-2">
    <axsl:apply-templates mode="M13" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p13-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:UntaxedForeignInterest" mode="M14" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 2000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8326</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC3] exceeds [£2,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC3] is valid only if this does not exceed [£2,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M14" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M14" priority="-1"/>
  <axsl:template match="@*|node()" mode="M14" priority="-2">
    <axsl:apply-templates mode="M14" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p14-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:TaxTakenOffForeignDividends" mode="M15" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (sum(../MTR:ForeignDividends) + 1) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8296</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC7] exceeds box [INC6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC7] should not exceed ( [INC6] + £1 )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M15" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M15" priority="-1"/>
  <axsl:template match="@*|node()" mode="M15" priority="-2">
    <axsl:apply-templates mode="M15" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p15-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:AnnualStatePension" mode="M16" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt; 99999"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6220</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC8] must be less than [£99,999]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC8] should be less than [£99,999]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M16" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M16" priority="-1"/>
  <axsl:template match="@*|node()" mode="M16" priority="-2">
    <axsl:apply-templates mode="M16" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p16-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:TaxTakenOffPensionLumpSum" mode="M17" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ((0.45 * sum(../MTR:StatePensionLumpSum)) + 1.0001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8297</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[INC10] is valid only if this does not exceed ( ( [45%] times [INC9] ) plus 1.00 )</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC10] is valid only if this does not exceed ( ( [45%] times [INC9] ) plus 1.00 )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M17" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M17" priority="-1"/>
  <axsl:template match="@*|node()" mode="M17" priority="-2">
    <axsl:apply-templates mode="M17" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p17-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:TaxTakenOffPensionsAndRetirementAnnuities" mode="M18" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:OtherPensionsAndRetirementAnnuities)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6221</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC12] exceeds the amount in box [INC11]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC12] should not exceed [INC11]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M18" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M18" priority="-1"/>
  <axsl:template match="@*|node()" mode="M18" priority="-2">
    <axsl:apply-templates mode="M18" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p18-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:TaxTakenOffIncapacityBenefit" mode="M19" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:IncapacityBenefit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6317</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Tax deducted entered in box [INC14] but no figure in [INC13]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If tax taken off incapacity benefit is present the following should be true: [INC13]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:IncapacityBenefit)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6035</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC14] exceeds the amount in box [INC13]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC14] should not exceed [INC13]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M19" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M19" priority="-1"/>
  <axsl:template match="@*|node()" mode="M19" priority="-2">
    <axsl:apply-templates mode="M19" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p19-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:JobseekersAllowance" mode="M20" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt; 99999"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6222</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC15] must be less than [£99,999]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC15] should be less than [£99,999]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M20" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M20" priority="-1"/>
  <axsl:template match="@*|node()" mode="M20" priority="-2">
    <axsl:apply-templates mode="M20" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p21-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:OtherUKIncome/MTR:OtherTaxableIncomeDetails/MTR:TaxTakenOffOtherTaxableIncome" mode="M21" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ../MTR:OtherTaxableIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6567</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [INC19] exceeds the amount in box [INC17]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[INC19] should not exceed [INC17]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M21" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M21" priority="-1"/>
  <axsl:template match="@*|node()" mode="M21" priority="-2">
    <axsl:apply-templates mode="M21" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p20-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:OtherUKIncome" mode="M22" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:OtherTaxableIncomeDetails/MTR:OtherTaxableIncome or MTR:DeemedIncomeOrBenefits)                    or                  MTR:DescriptionOfOtherIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6568</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [INC17] and/or [INC20]. Please complete box [INC21]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>description of other income should be present if [INC17] or [INC20]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M22" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M22" priority="-1"/>
  <axsl:template match="@*|node()" mode="M22" priority="-2">
    <axsl:apply-templates mode="M22" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p22-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:CharitableGiving/MTR:OneOffGiftAidPayments" mode="M23" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:GiftAidPaymentsMadeInYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6129</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [REL6] exceeds the amount in box [REL5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[REL6] shoold not exceed [REL5]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M23" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M23" priority="-1"/>
  <axsl:template match="@*|node()" mode="M23" priority="-2">
    <axsl:apply-templates mode="M23" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p23-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:CharitableGiving/MTR:GiftAidPaymentsCarriedBackToPreviousYear" mode="M24" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:GiftAidPaymentsMadeInYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6360</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [REL7] exceeds the amount in box [REL5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[REL7] should not exceed [REL5]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M24" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M24" priority="-1"/>
  <axsl:template match="@*|node()" mode="M24" priority="-2">
    <axsl:apply-templates mode="M24" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p24-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:CharitableGiving/MTR:InvestmentsGiftedToNonUKCharities" mode="M25" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) &lt;= 0                     or                   (((.)) - ((sum(../MTR:SharesGiftedToCharity) + sum(../MTR:LandAndBuildingsGiftedToCharity))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8211</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As the entry in box [REL11] is greater than zero, the amount in box [REL11] must be less than or equal to ([REL9] + [REL10]). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [REL11] is greater than zero then [REL11] must be less than or equal to ([REL9] + [REL10])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M25" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M25" priority="-1"/>
  <axsl:template match="@*|node()" mode="M25" priority="-2">
    <axsl:apply-templates mode="M25" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p25-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:CharitableGiving/MTR:DonationsToNonUKCharities" mode="M26" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) &lt;= 0                     or                   (((.)) - (sum(../MTR:GiftAidPaymentsMadeInYear)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8212</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As the entry in box [REL12] is greater than zero, the amount in box [REL12] must be less than or equal to [REL5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [REL12] is greater than zero then [REL12] must be less than or equal to [REL5]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M26" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M26" priority="-1"/>
  <axsl:template match="@*|node()" mode="M26" priority="-2">
    <axsl:apply-templates mode="M26" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p26-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:BlindPersonsAllowance/MTR:BlindPersonsAllowanceDetails/MTR:SurplusBlindPersonsAllowanceToSpouse" mode="M27" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusBlindPersonsAllowance)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6512</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [REL16], box [CAL12] must be absent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [REL16] is present [CAL12] must be absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M27" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M27" priority="-1"/>
  <axsl:template match="@*|node()" mode="M27" priority="-2">
    <axsl:apply-templates mode="M27" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p27-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:BlindPersonsAllowance/MTR:BlindPersonsAllowanceDetails/MTR:LocalAuthorityName" mode="M28" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:RegisteredBlind"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6261</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry at box [REL14], please complete box [REL13].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>if [REL14] is present, [REL13] should also be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M28" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M28" priority="-1"/>
  <axsl:template match="@*|node()" mode="M28" priority="-2">
    <axsl:apply-templates mode="M28" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p28-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:BlindPersonsAllowance/MTR:SurplusBlindPersonsAllowanceFromSpouse" mode="M29" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusBlindPersonsAllowance"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6732</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [REL15]. Please complete box [CAL12].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CAL12] Must be present if [REL15] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M29" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M29" priority="-1"/>
  <axsl:template match="@*|node()" mode="M29" priority="-2">
    <axsl:apply-templates mode="M29" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p30-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:HighIncomeChildBenefitCharge/MTR:NumberOfChildren" mode="M30" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 0 or ../MTR:AmountReceived"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8298</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [CBC2] is present and greater than 0, then [CBC1] must be present.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [CBC2] is present and greater than 0, then [CBC1] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M30" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M30" priority="-1"/>
  <axsl:template match="@*|node()" mode="M30" priority="-2">
    <axsl:apply-templates mode="M30" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p31-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:HighIncomeChildBenefitCharge/MTR:DateStoppedReceivingAllChildBenefitPayments" mode="M31" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AmountReceived"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8311</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[CBC1] must be present if [CBC3] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CBC1] should be present if [CBC3] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfChildren"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8312</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[CBC2] must be present if [CBC3] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CBC2] should be present if [CBC3] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8313</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[CBC3] must be within the current return year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CBC3] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M31" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M31" priority="-1"/>
  <axsl:template match="@*|node()" mode="M31" priority="-2">
    <axsl:apply-templates mode="M31" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p29-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:HighIncomeChildBenefitCharge" mode="M32" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:AmountReceived or MTR:NumberOfChildren"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8310</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[CBC1-3] is present so the following should be true: [CBC1] is present or [CBC2] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [CBC1-3] is present the following should be true: [CBC1] is present or [CBC2] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M32" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M32" priority="-1"/>
  <axsl:template match="@*|node()" mode="M32" priority="-2">
    <axsl:apply-templates mode="M32" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p32-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:MarriageAllowance/MTR:SpouseFirstName" mode="M33" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:MarriageAllowanceTransferredOut"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8327</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [MAT1]. Please complete [MAT-OUT]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MAT-OUT] should be present if [MAT1] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M33" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M33" priority="-1"/>
  <axsl:template match="@*|node()" mode="M33" priority="-2">
    <axsl:apply-templates mode="M33" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p33-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:MarriageAllowance/MTR:DateOfMarriageOrCivilPartnership" mode="M34" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(&quot;2016-04-05&quot;)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8330</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in [MAT5] must be on or before [5 April 2016]</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MAT5] is valid only if this is on or before [5 April 2016]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M34" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M34" priority="-1"/>
  <axsl:template match="@*|node()" mode="M34" priority="-2">
    <axsl:apply-templates mode="M34" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p35-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:PaymentDetails/MTR:NomineeDetails/MTR:NomineeAddress" mode="M35" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShortLine) or (count(MTR:Line) = 3)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8253</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If line 4 is present lines 1,2 &amp; 3 must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M35" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M35" priority="-1"/>
  <axsl:template match="@*|node()" mode="M35" priority="-2">
    <axsl:apply-templates mode="M35" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p34-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:PaymentDetails/MTR:NomineeDetails" mode="M36" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:BankAccountDetails/MTR:AccountHolderOrNomineeName"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6223</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There are entries in [FIN10] and [FIN12-FIN13]. Please complete box [FIN5].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FIN10] and [FIN12-FIN13] are present. [FIN5] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M36" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M36" priority="-1"/>
  <axsl:template match="@*|node()" mode="M36" priority="-2">
    <axsl:apply-templates mode="M36" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p36-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:TaxAdviser/MTR:TaxAdviserAddress" mode="M37" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShortLine) or (count(MTR:Line) = 3)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8253</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If line 4 is present lines 1,2 &amp; 3 must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M37" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M37" priority="-1"/>
  <axsl:template match="@*|node()" mode="M37" priority="-2">
    <axsl:apply-templates mode="M37" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p37-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:SigningYourForm/MTR:AddressOfPersonSigning" mode="M38" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShortLine) or (count(MTR:Line) = 3)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8253</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If line 4 is present lines 1,2 &amp; 3 must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M38" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M38" priority="-1"/>
  <axsl:template match="@*|node()" mode="M38" priority="-2">
    <axsl:apply-templates mode="M38" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p38-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:ChargeableEventGains" mode="M39" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not ( ../../MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsNoTaxTreatedAsPaid/MTR:NumberOfYears or ../../MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsTaxTreatedAsPaid/MTR:NumberOfYears or ../../MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsFromVoidedISAs/MTR:NumberOfYears or ../../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NumberOfYearsSincePolicyMade )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6525</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box1A present then boxes [AOI7], [AOI5], [AOI9] and [FOR44] must be absent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If Box1A present then boxes [AOI7], [AOI5], [AOI9] and [FOR44] must be absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M39" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M39" priority="-1"/>
  <axsl:template match="@*|node()" mode="M39" priority="-2">
    <axsl:apply-templates mode="M39" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p4-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100" mode="M40" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:YourTaxReturn/MTR:MinisterOfReligionSchedule) or MTR:YourTaxReturn/MTR:NumberOfMinisterOfReligionSchedules"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6180</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [YTR1A.1A]. Please complete box [YTR1A.1B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Number of Minister of Religion Schedules should be present if [YTR1A.1A] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M40" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M40" priority="-1"/>
  <axsl:template match="@*|node()" mode="M40" priority="-2">
    <axsl:apply-templates mode="M40" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p40-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsTaxTreatedAsPaid/MTR:NumberOfYears" mode="M41" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AmountOfGain"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6250</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Number of years entered in box [AOI5], but no gain in box [AOI4]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If number of years is present the following should be true: [AOI4]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M41" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M41" priority="-1"/>
  <axsl:template match="@*|node()" mode="M41" priority="-2">
    <axsl:apply-templates mode="M41" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p41-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsNoTaxTreatedAsPaid/MTR:NumberOfYears" mode="M42" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AmountOfGain"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6256</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Number of years entered in box [AOI7] but no gain in box [AOI6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If number of years is present the following should be true: [AOI6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M42" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M42" priority="-1"/>
  <axsl:template match="@*|node()" mode="M42" priority="-2">
    <axsl:apply-templates mode="M42" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p42-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsFromVoidedISAs/MTR:NumberOfYears" mode="M43" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AmountOfGain"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6316</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Number of years entered in box [AOI9] but no gain in box [AOI8]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If number of years  is present the following should be true: [AOI8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M43" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M43" priority="-1"/>
  <axsl:template match="@*|node()" mode="M43" priority="-2">
    <axsl:apply-templates mode="M43" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p43-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:TaxTakenOffLumpSumsLeftBlank" mode="M44" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(../MTR:LumpSums/MTR:TaxTakenOff) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6358</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [ASE7] must be absent if there is an entry greater than zero in box [ASE6]</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[ASE7] must be absent if there is an entry greater than zero in box [ASE6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../../MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay)) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6357</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [ASE7]. There must be an entry greater than zero in box [EMP2]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [ASE7] is present [EMP2] must be greater than zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M44" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M44" priority="-1"/>
  <axsl:template match="@*|node()" mode="M44" priority="-2">
    <axsl:apply-templates mode="M44" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p44-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:CompensationAndLumpSumExemption" mode="M45" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 30000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6257</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [ASE9] exceeds the maximum relief allowable of [£30,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[ASE9] should not exceed [£30,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M45" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M45" priority="-1"/>
  <axsl:template match="@*|node()" mode="M45" priority="-2">
    <axsl:apply-templates mode="M45" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p45-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:SeafarersEarningsDeduction" mode="M46" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (1.00 + sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) )) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6526</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [ASE11] exceeds the total of boxes ( [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]) less ( [ASE12] + [EMP19] + [EMP18] + [EMP20] + [EMP17]). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in [ASE11] it must not exceed by more than £1 the total of boxes( [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]) less ( [ASE12] + [EMP19] + [EMP18] + [EMP20] + [EMP17])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M46" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M46" priority="-1"/>
  <axsl:template match="@*|node()" mode="M46" priority="-2">
    <axsl:apply-templates mode="M46" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p46-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:NonUKTaxableForeignEarnings" mode="M47" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (1.00 + sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) +  sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6429</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [ASE12] exceeds the total of boxes [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in [ASE12] it must not exceed by more than £1  the total of boxes [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] (error 429)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M47" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M47" priority="-1"/>
  <axsl:template match="@*|node()" mode="M47" priority="-2">
    <axsl:apply-templates mode="M47" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p47-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:ForeignTaxNoForeignTaxCreditReliefClaim" mode="M48" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(   (((( sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) ) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../MTR:SeafarersEarningsDeduction) ))) - (0) &lt;= -0.001) and ((.) - (1) &lt; 0.001) )  or  (   (((( sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) ) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../MTR:SeafarersEarningsDeduction) ))) - (0) &gt; -0.001) and ((.) - (1 + (( sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) ) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../MTR:SeafarersEarningsDeduction) ))) &lt; 0.001) )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6527</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [ASE13] exceeds the  total of boxes ( [MOR38] + [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] ) less ( [ASE12] + [EMP17] + [EMP18] + [EMP19] + [EMP20] + [ASE11]). Please check.  If the sum is negative please treat as zero.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in box [ASE13] it must not exceed by more than £1 the total of ( [MOR38] + [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] ) less ( [ASE12] + [EMP17] + [EMP18] + [EMP19] + [EMP20] + [ASE11]). If the sum is negative treat as zero.(error 431)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M48" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M48" priority="-1"/>
  <axsl:template match="@*|node()" mode="M48" priority="-2">
    <axsl:apply-templates mode="M48" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p48-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:VentureCapitalTrustShareSubscriptions" mode="M49" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 200000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6280</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [AOR1] exceeds the maximum relief allowable of [£200,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
venture capital trust share subscriptions is valid if and only if this does not exceed [£200,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M49" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M49" priority="-1"/>
  <axsl:template match="@*|node()" mode="M49" priority="-2">
    <axsl:apply-templates mode="M49" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p49-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:EnterpriseInvestmentSchemeShareSubscriptions" mode="M50" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 1000000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6268</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [AOR2] exceeds the maximum relief allowable of [£1,000,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[AOR2] should not exceed [£1,000,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M50" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M50" priority="-1"/>
  <axsl:template match="@*|node()" mode="M50" priority="-2">
    <axsl:apply-templates mode="M50" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p50-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:MaintenanceOrAlimonyPayments" mode="M51" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 3220"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6409</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [AOR7] exceeds the upper limit for relief of  [£3,220]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[AOR7] is valid only if this does not exceed [£3,220]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M51" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M51" priority="-1"/>
  <axsl:template match="@*|node()" mode="M51" priority="-2">
    <axsl:apply-templates mode="M51" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p51-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:TradeUnionEtcDeathBenefitPayments" mode="M52" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 100"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6022</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [AOR8] exceeds [£100]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must not exceed [£100]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M52" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M52" priority="-1"/>
  <axsl:template match="@*|node()" mode="M52" priority="-2">
    <axsl:apply-templates mode="M52" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p52-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:SeedEnterpriseInvestmentSchemeAmount" mode="M53" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 100000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8291</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [AOR10] exceeds the maximum relief allowable of [£100,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[AOR10] is valid only if this does not exceed [£100,000].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M53" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M53" priority="-1"/>
  <axsl:template match="@*|node()" mode="M53" priority="-2">
    <axsl:apply-templates mode="M53" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p53-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:SocialInvestmentTaxRelief" mode="M54" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 1000000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8314</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[AOR11] is valid only if this does not exceed [£1,000,000]</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[AOR11] is valid only if this does not exceed [£1,000,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M54" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M54" priority="-1"/>
  <axsl:template match="@*|node()" mode="M54" priority="-2">
    <axsl:apply-templates mode="M54" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p54-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:HigherEarner/MTR:SpousesName" mode="M55" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(translate(../MTR:SpousesDateOfBirth,'-','') &lt; 19350406) or (translate(../MTR:PreviousSpousesDateOfBirth,'-','') &lt; 19350406) or (translate(../../../../MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth,'-','') &lt; 19350406)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6064</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [MCA1]. An entry must be present in at least one of boxes [MCA2], [MCA5] or [YPD1] with a date before 6th April 1935. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [MCA1] present then at least one of [MCA2], [MCA5] or [YPD1] must be present with a date before 6th April 1935</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../MTR:SA100/MTR:MarriageAllowance/MTR:SpouseFirstName)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8331</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [MCA1] should not be present as there is an entry in box [MAT1]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MCA1] should not be present if [MAT1] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M55" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M55" priority="-1"/>
  <axsl:template match="@*|node()" mode="M55" priority="-2">
    <axsl:apply-templates mode="M55" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p55-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:HigherEarner/MTR:SpousesDateOfBirth" mode="M56" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space((.))) div 86400) &lt; round(date:seconds(normalize-space(&quot;1935-04-06&quot;)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6102</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If present date of birth must be before 6 April 1935.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MCA2] must be before 6th April 1935</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M56" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M56" priority="-1"/>
  <axsl:template match="@*|node()" mode="M56" priority="-2">
    <axsl:apply-templates mode="M56" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p56-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:HigherEarner/MTR:AllMinimumAllowanceTransferToOther" mode="M57" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) and not (../MTR:HalfMinimumAllowanceTransferToOther))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6419</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [MCA3] completed, you cannot complete box [MCA4]. Please amend box [MCA3] or [MCA4].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If present, [MCA3] must be absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M57" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M57" priority="-1"/>
  <axsl:template match="@*|node()" mode="M57" priority="-2">
    <axsl:apply-templates mode="M57" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p57-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:LowerEarner/MTR:SpousesName" mode="M58" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../MTR:SA100/MTR:MarriageAllowance/MTR:SpouseFirstName)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8332</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [MCA8] should not be present as there is an entry in box [MAT1]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MCA8] should not be present if [MAT1] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M58" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M58" priority="-1"/>
  <axsl:template match="@*|node()" mode="M58" priority="-2">
    <axsl:apply-templates mode="M58" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p58-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:DateOfMarriageOrCivilPartnership" mode="M59" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6414</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MCA9] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M59" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M59" priority="-1"/>
  <axsl:template match="@*|node()" mode="M59" priority="-2">
    <axsl:apply-templates mode="M59" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p59-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:SurplusAllowanceFromSpouse" mode="M60" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusMarriedCouplesAllowance"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6529</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [CAL13] must be completed if box [MCA10] completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CAL13] must be present if [MCA10] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M60" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M60" priority="-1"/>
  <axsl:template match="@*|node()" mode="M60" priority="-2">
    <axsl:apply-templates mode="M60" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p60-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:SurplusAllowanceToSpouse" mode="M61" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusMarriedCouplesAllowance)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6303</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [MCA11] completed. You cannot complete box [CAL13]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [MCA11] is present [CAL13] must be absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M61" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M61" priority="-1"/>
  <axsl:template match="@*|node()" mode="M61" priority="-2">
    <axsl:apply-templates mode="M61" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p61-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:NextYearsUncappedLossRelief" mode="M62" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (sum(../MTR:NextYearsTradingAndCapitalLossesRelief)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8299</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[AIL4] is valid only if this does not exceed [AIL3].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[AIL4] is valid only if this does not exceed [AIL3].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M62" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M62" priority="-1"/>
  <axsl:template match="@*|node()" mode="M62" priority="-2">
    <axsl:apply-templates mode="M62" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p62-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:YearForWhichReliefClaimed" mode="M63" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(number(substring(string(.) , 1 , 4)) - number(substring(string(.) , 6 , 2))) mod 100 = 99"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6227</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must be a valid pair of consecutive years in the format YYYY YY</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NextYearsTradingAndCapitalLossesRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6551</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [AIL5], an entry must be present in [AIL3]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If year for which relief claimed is present the following should be true: [AIL3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M63" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M63" priority="-1"/>
  <axsl:template match="@*|node()" mode="M63" priority="-2">
    <axsl:apply-templates mode="M63" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p63-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:PensionTaxAndLumpSums/MTR:AnnualAllowanceTaxPaidByPensionScheme" mode="M64" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt; sum(../MTR:AmountSavedExceedingAnnualAllowance)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8254</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [AIL11] must be less than [AIL10]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[AIL11] is valid if and only if this is less than [AIL10]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M64" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M64" priority="-1"/>
  <axsl:template match="@*|node()" mode="M64" priority="-2">
    <axsl:apply-templates mode="M64" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p39-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101" mode="M65" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((sum(MTR:SharesEmploymentCompensationsAndDeductions/MTR:SeafarersEarningsDeduction)) - (0) &gt;= 0.001))             or           MTR:OtherInformation/MTR:AdditionalInformation"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6225</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [ASE11] is greater than zero. Please complete box [AIL21].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [ASE11] is present and greater than zero then [AIL21] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M65" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M65" priority="-1"/>
  <axsl:template match="@*|node()" mode="M65" priority="-2">
    <axsl:apply-templates mode="M65" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p64-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay" mode="M66" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(1 = count(../../../MTR:SA102/MTR:Employment)) or . &gt;= 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6504</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">This box must not be negative because there is only one employment page present..</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>May be negative if more than one set employment pages present. Must not be negative if only one employment page present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M66" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M66" priority="-1"/>
  <axsl:template match="@*|node()" mode="M66" priority="-2">
    <axsl:apply-templates mode="M66" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p65-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:DateCeasedBeingADirector" mode="M67" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:CompanyDirector = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8315</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[EMP6] must equal 'yes' if [EMP6.1] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[EMP6] should equal 'yes' if [EMP6.1] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8323</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[EMP6.1] must be within the current return year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[EMP6.1] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M67" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M67" priority="-1"/>
  <axsl:template match="@*|node()" mode="M67" priority="-2">
    <axsl:apply-templates mode="M67" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p67-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TaxTakenOffSalaryStipend" mode="M68" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:SalaryOrStipend"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6792</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [MOR3]. Please complete box [MOR2].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If tax taken off salary/stipend is present the following should be true: [MOR2]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M68" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M68" priority="-1"/>
  <axsl:template match="@*|node()" mode="M68" priority="-2">
    <axsl:apply-templates mode="M68" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p68-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TaxTakenOffRoundSumExpenses" mode="M69" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:RoundSumExpensesAndRentAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6794</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [MOR9]. Please complete box [MOR8].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If tax taken off box 8 is present the following should be true: [MOR8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M69" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M69" priority="-1"/>
  <axsl:template match="@*|node()" mode="M69" priority="-2">
    <axsl:apply-templates mode="M69" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p69-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TaxTakenOffOtherIncome" mode="M70" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:OtherIncomeFromPost"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6795</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [MOR11]. Please complete box [MOR10].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If tax taken off other income is present the following should be true: [MOR10]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M70" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M70" priority="-1"/>
  <axsl:template match="@*|node()" mode="M70" priority="-2">
    <axsl:apply-templates mode="M70" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p70-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" mode="M71" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:SalaryOrStipend) + sum(../MTR:FeesAndOfferings) + sum(../MTR:VicarageManseExpenses) + sum(../MTR:PersonalExpensesEtcPaid) + sum(../MTR:ExcessMileageAllowanceEtc) + sum(../MTR:RoundSumExpensesAndRentAllowances) + sum(../MTR:OtherIncomeFromPost)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6028</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR12] must equal ( the sum of [MOR2], [MOR4], [MOR5], [MOR6], [MOR7], [MOR8], and [MOR10] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>

total income as Minister of Religion is valid if and only if this equals ( The sum of [MOR2], [MOR4], [MOR5], [MOR6], [MOR7], [MOR8], and [MOR10] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M71" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M71" priority="-1"/>
  <axsl:template match="@*|node()" mode="M71" priority="-2">
    <axsl:apply-templates mode="M71" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p71-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses" mode="M72" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:VicarageServicesBenefit) + sum(../MTR:CarProvided) + sum(../MTR:FuelForCarProvided) + sum(../MTR:InterestFreeLoans) + sum(../MTR:ExpensesPaymentsMade) + sum(../MTR:OtherBenefits)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6039</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR19] must equal ( the sum of [MOR13], [MOR14], [MOR15], [MOR16], [MOR17], and [MOR18] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MOR19] should equal ( The sum of [MOR13], [MOR14], [MOR15], [MOR16], [MOR17], and [MOR18] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M72" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M72" priority="-1"/>
  <axsl:template match="@*|node()" mode="M72" priority="-2">
    <axsl:apply-templates mode="M72" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p72-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:IncomeBenefitsAndExpensesReceived" mode="M73" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) + sum(../MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6796</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR20] exceeds ( [MOR12] plus [MOR19] ). Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MOR20] should not exceed ( [MOR12] plus [MOR19] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((sum(../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) + sum(../MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses)) - (8500) &lt;= -0.001)) or (math:abs((.) - (sum(../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) - sum(../MTR:Income/MTR:VicarageManseExpenses))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6228</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As the sum of [MOR12] plus [MOR19] is less than [£8,500], the amount in box [MOR20] must equal [MOR12] minus [MOR5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [MOR12] + [MOR19] is less than [£8,500] then [MOR20] must equal [MOR12] minus [MOR5].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) + sum(../MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses)) - (8500) &lt;= -0.001) or (math:abs((.) - (sum(../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) + sum(../MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6229</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As the sum of [MOR12] plus [MOR19] is [£8,500] or more, the amount in box [MOR20] must equal [MOR12] plus [MOR19]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [MOR12] + [MOR19] is not less than [£8,500] then [MOR20] must equal [MOR12] + [MOR19].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M73" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M73" priority="-1"/>
  <axsl:template match="@*|node()" mode="M73" priority="-2">
    <axsl:apply-templates mode="M73" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p73-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid" mode="M74" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:RentExpenses) + sum(../MTR:MaintenanceAndRepairsEtc) + sum(../MTR:TravellingExpensesAndCapitalAllowances) + sum(../MTR:SecretarialAssistance) + sum(../MTR:OtherExpenses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6040</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR26] must equal ( the sum of [MOR23], [MOR22], [MOR21], [MOR24], and [MOR25] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
total expenses paid is valid if and only if this equals ( The sum of [MOR23], [MOR22], [MOR21], [MOR24], and [MOR25] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M74" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M74" priority="-1"/>
  <axsl:template match="@*|node()" mode="M74" priority="-2">
    <axsl:apply-templates mode="M74" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p74-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:GrossIncome" mode="M75" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (sum(../../MTR:IncomeBenefitsAndExpensesReceived) - (sum(../../MTR:Income/MTR:VicarageManseExpenses) + sum(../../MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6041</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR27] exceeds the amount of [MOR20] minus ([MOR5] plus [MOR13]). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If present, [MOR27] must not exceed  [MOR20] - ([MOR5] + [MOR13]) </axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((sum(../../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) + sum(../../MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses)) - (8500) &gt; -0.001)) or (math:abs((.) - (sum(../../MTR:IncomeBenefitsAndExpensesReceived) - (sum(../../MTR:Income/MTR:VicarageManseExpenses) + sum(../../MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6230</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As the sum of [MOR12] + [MOR19] is greater or equal to [£8,500] then this must equal [MOR20] minus ( [MOR5] + [MOR13] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [MOR12] + [MOR19] &gt;= [£8,500] then [MOR27] must equal [MOR20] minus ( [MOR5] + [MOR13] ).</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M75" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M75" priority="-1"/>
  <axsl:template match="@*|node()" mode="M75" priority="-2">
    <axsl:apply-templates mode="M75" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p75-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:NetIncome" mode="M76" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:GrossIncome) + sum(../MTR:BackpayReceivedAfterYearEnd)) - (sum(../../MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid) + sum(../MTR:EarlierYearsBackpayReceivedInYear) + sum(../MTR:PensionSchemePayments))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6231</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR31] must equal ( ( [MOR27] plus [MOR28] ) minus ( the sum of [MOR26], [MOR29], and [MOR30] ) ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MOR31] should equal ( ( [MOR27] plus [MOR28] ) minus ( The sum of [MOR26], [MOR29], and [MOR30] ) )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M76" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M76" priority="-1"/>
  <axsl:template match="@*|node()" mode="M76" priority="-2">
    <axsl:apply-templates mode="M76" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p76-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:TenPercentOfNetIncome" mode="M77" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:NetIncome) or ((.) - ((sum(../MTR:NetIncome) div 10) + 1.00) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6232</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR32] must be less than or equal to ([MOR31] x 10%). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [MOR31] present, it must be less than or equal to ([MOR31] x 10%) + £1</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M77" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M77" priority="-1"/>
  <axsl:template match="@*|node()" mode="M77" priority="-2">
    <axsl:apply-templates mode="M77" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p77-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:PaymentsMadeAndServiceBenefitReceived" mode="M78" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:Income/MTR:VicarageManseExpenses) + sum(../../MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6233</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR34] must equal ( [MOR5] plus [MOR13] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MOR34] should equal ( [MOR5] plus [MOR13] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M78" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M78" priority="-1"/>
  <axsl:template match="@*|node()" mode="M78" priority="-2">
    <axsl:apply-templates mode="M78" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p78-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:ServiceBenefitCap" mode="M79" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((number(.)) - (sum(../MTR:AmountPaidTowardServiceBenefit) + sum(../MTR:PaymentsMadeAndServiceBenefitReceived) - sum(../MTR:TenPercentOfNetIncome))) &lt; 0.001) or (((sum(../MTR:AmountPaidTowardServiceBenefit) + sum(../MTR:PaymentsMadeAndServiceBenefitReceived) - sum(../MTR:TenPercentOfNetIncome)) - (0) &lt;= -0.001) and number(.) = 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6049</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR35] must equal ( [MOR33] plus [MOR34] minus [MOR32] ). Please check.  </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MOR35] should equal ( [MOR33] plus [MOR34] minus [MOR32] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M79" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M79" priority="-1"/>
  <axsl:template match="@*|node()" mode="M79" priority="-2">
    <axsl:apply-templates mode="M79" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p79-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:OtherIncome/MTR:TaxTakenOfOtherIncome" mode="M80" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:ChaplaincyAndOtherIncome)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6050</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR37] exceeds [MOR36]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
tax taken of other income is valid if and only if this does not exceed [MOR36]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:ChaplaincyAndOtherIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6590</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [MOR37]. Please complete box [MOR36].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If tax taken of other income is present the following should be true: [MOR36]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M80" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M80" priority="-1"/>
  <axsl:template match="@*|node()" mode="M80" priority="-2">
    <axsl:apply-templates mode="M80" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p80-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses" mode="M81" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../../MTR:IncomeBenefitsAndExpensesReceived) + sum(../../MTR:OtherIncome/MTR:ChaplaincyAndOtherIncome)) - (sum(../../MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid) + sum(../../MTR:ServiceBenefitCap/MTR:ServiceBenefitCap))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6051</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR38] must equal ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
taxable income minus expenses is valid if and only if this equals ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M81" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M81" priority="-1"/>
  <axsl:template match="@*|node()" mode="M81" priority="-2">
    <axsl:apply-templates mode="M81" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p81-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:TaxableIncome/MTR:TotalTaxTakenOff" mode="M82" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:Income/MTR:TaxTakenOffSalaryStipend) + sum(../../MTR:Income/MTR:TaxTakenOffRoundSumExpenses) + sum(../../MTR:Income/MTR:TaxTakenOffOtherIncome) + sum(../../MTR:OtherIncome/MTR:TaxTakenOfOtherIncome)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6052</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [MOR39] must equal ( the sum of [MOR3], [MOR9], [MOR11], and [MOR37] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[MOR39] should equal ( The sum of [MOR3], [MOR9], [MOR11], and [MOR37] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M82" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M82" priority="-1"/>
  <axsl:template match="@*|node()" mode="M82" priority="-2">
    <axsl:apply-templates mode="M82" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p66-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M" mode="M83" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:Income/MTR:SalaryOrStipend or MTR:Income/MTR:FeesAndOfferings or MTR:Income/MTR:VicarageManseExpenses or MTR:Income/MTR:PersonalExpensesEtcPaid or MTR:Income/MTR:ExcessMileageAllowanceEtc or MTR:Income/MTR:RoundSumExpensesAndRentAllowances or MTR:Income/MTR:OtherIncomeFromPost) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6023</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [MOR2] or [MOR4] or [MOR5] or [MOR6] or [MOR7] or [MOR8] or [MOR10]. Please complete box [MOR12].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total income as Minister of Religion should be present if [MOR2] or [MOR4] or [MOR5] or [MOR6] or [MOR7] or [MOR8] or [MOR10]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit or MTR:BenefitsAndExpensePaymentsToYou/MTR:CarProvided or MTR:BenefitsAndExpensePaymentsToYou/MTR:FuelForCarProvided or MTR:BenefitsAndExpensePaymentsToYou/MTR:InterestFreeLoans or MTR:BenefitsAndExpensePaymentsToYou/MTR:ExpensesPaymentsMade or MTR:BenefitsAndExpensePaymentsToYou/MTR:OtherBenefits) or MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6024</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [MOR13] or [MOR14] or [MOR15] or [MOR16] or [MOR17] or [MOR18]. Please complete [MOR19].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total benefits and expenses should be present if [MOR13] or [MOR14] or [MOR15] or [MOR16] or [MOR17] or [MOR18]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:Income/MTR:TotalIncomeAsMinisterOfReligion or MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses) or MTR:IncomeBenefitsAndExpensesReceived"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6025</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [MOR12] or [MOR19]. Please complete box [MOR20].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>income, benefits and expenses received should be present if [MOR12] or [MOR19]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ExpensesPaidByYou/MTR:TravellingExpensesAndCapitalAllowances or MTR:ExpensesPaidByYou/MTR:MaintenanceAndRepairsEtc or MTR:ExpensesPaidByYou/MTR:RentExpenses or MTR:ExpensesPaidByYou/MTR:SecretarialAssistance or MTR:ExpensesPaidByYou/MTR:OtherExpenses) or MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6026</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [MOR21] or [MOR22] or [MOR23] or [MOR24] or [MOR25]. Please complete [MOR26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total expenses paid should be present if [MOR21] or [MOR22] or [MOR23] or [MOR24] or [MOR25]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:IncomeBenefitsAndExpensesReceived) + sum(MTR:OtherIncome/MTR:ChaplaincyAndOtherIncome)) - (sum(MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid) + sum(MTR:ServiceBenefitCap/MTR:ServiceBenefitCap)))) - (0) &gt;= 0.001)) or MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6029</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ) exceeds 0. Please complete [MOR38].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxable income minus expenses should be present if ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:Income/MTR:TaxTakenOffSalaryStipend or MTR:Income/MTR:TaxTakenOffRoundSumExpenses or MTR:Income/MTR:TaxTakenOffOtherIncome or MTR:OtherIncome/MTR:TaxTakenOfOtherIncome) or MTR:TaxableIncome/MTR:TotalTaxTakenOff"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6030</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [MOR3] or [MOR9] or [MOR11] or [MOR37]. Please complete [MOR39].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total tax taken off should be present if [MOR3] or [MOR9] or [MOR11] or [MOR37]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M83" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M83" priority="-1"/>
  <axsl:template match="@*|node()" mode="M83" priority="-2">
    <axsl:apply-templates mode="M83" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p83-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DateBusinessStarted" mode="M84" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6433</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE6] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M84" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M84" priority="-1"/>
  <axsl:template match="@*|node()" mode="M84" priority="-2">
    <axsl:apply-templates mode="M84" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p84-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DateBusinessCeased" mode="M85" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6433</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE7] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:DateBusinessStarted) or starts-with(date:difference(normalize-space(../MTR:DateBusinessStarted), normalize-space((.))), 'P')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6434</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date cannot be earlier than [FSE6]. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must be the same as or later than [FSE6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M85" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M85" priority="-1"/>
  <axsl:template match="@*|node()" mode="M85" priority="-2">
    <axsl:apply-templates mode="M85" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p85-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DateAccountingPeriodEnds" mode="M86" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(number(translate(.,'-','')) &gt;= number(translate(../MTR:DateAccountingPeriodStarts,'-',''))) or not (../MTR:DateAccountingPeriodStarts)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6195</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date cannot be earlier than [FSE8]. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FSE8] is present, Must be the same as or later than [FSE8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DateAccountingPeriodStarts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6061</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is a date entered in [FSE9]. Please enter a date in [FSE8].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If date accounting period ends is present the following should be true: [FSE8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M86" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M86" priority="-1"/>
  <axsl:template match="@*|node()" mode="M86" priority="-2">
    <axsl:apply-templates mode="M86" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p86-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:CashBasis" mode="M87" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../../MTR:Losses/MTR:LossOfYearSetAgainstOtherIncome) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8300</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [FSE10] is present, then [FSE78] must be zero or absent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FSE10] is present, then [FSE78] must be zero or absent.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M87" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M87" priority="-1"/>
  <axsl:template match="@*|node()" mode="M87" priority="-2">
    <axsl:apply-templates mode="M87" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p87-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessIncome/MTR:Turnover" mode="M88" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:BusinessDetails/MTR:DateAccountingPeriodStarts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6435</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [FSE15]. Please complete box [FSE8].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If turnover is present the following should be true: [FSE8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M88" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M88" priority="-1"/>
  <axsl:template match="@*|node()" mode="M88" priority="-2">
    <axsl:apply-templates mode="M88" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p88-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessIncome/MTR:OtherBusinessIncome" mode="M89" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:BusinessDetails/MTR:DateAccountingPeriodStarts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6437</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [FSE16]. Please complete box [FSE8].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If other business income is present the following should be true: [FSE8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M89" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M89" priority="-1"/>
  <axsl:template match="@*|node()" mode="M89" priority="-2">
    <axsl:apply-templates mode="M89" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p89-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses" mode="M90" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:CostOfGoods or ../MTR:SubcontractorCosts or ../MTR:WagesSalariesAndStaffCosts or ../MTR:CarVanAndTravelExpenses or ../MTR:RentAndOtherPropertyCosts or ../MTR:RepairAndRenewalCosts or ../MTR:PhoneAndOtherOfficeCosts or ../MTR:AdvertisingAndEntertainmentCosts or ../MTR:BankAndLoanInterest or ../MTR:OtherFinanceCharges or ../MTR:DebtsWrittenOff or ../MTR:AccountancyAndLegalFees or ../MTR:DepreciationAndLossProfitOnSale or ../MTR:OtherBusinessExpenses)  or  ((math:abs(((.)) - ((sum(../MTR:CostOfGoods) + sum(../MTR:SubcontractorCosts) + sum(../MTR:WagesSalariesAndStaffCosts) + sum(../MTR:CarVanAndTravelExpenses) + sum(../MTR:RentAndOtherPropertyCosts) + sum(../MTR:RepairAndRenewalCosts) + sum(../MTR:PhoneAndOtherOfficeCosts) + sum(../MTR:AdvertisingAndEntertainmentCosts) + sum(../MTR:BankAndLoanInterest) + sum(../MTR:OtherFinanceCharges) + sum(../MTR:DebtsWrittenOff) + sum(../MTR:AccountancyAndLegalFees) + sum(../MTR:DepreciationAndLossProfitOnSale) + sum(../MTR:OtherBusinessExpenses)))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6053</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE31] must equal ( the sum of [FSE17],[FSE18],[FSE19],[FSE20],[FSE21],[FSE22],[FSE23],[FSE24],[FSE25],[FSE26],[FSE27],[FSE28],[FSE29] and [FSE30] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If entry in any of [FSE17],[FSE18],[FSE19],[FSE20],[FSE21],[FSE22],[FSE23],[FSE24],[FSE25],[FSE26],[FSE27],[FSE28],[FSE29] or [FSE30] total of all boxes must = [FSE31]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M90" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M90" priority="-1"/>
  <axsl:template match="@*|node()" mode="M90" priority="-2">
    <axsl:apply-templates mode="M90" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p90-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses" mode="M91" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(                        ../MTR:DisallowableCostOfGoods                     or ../MTR:DisallowableSubcontractorCosts                     or ../MTR:DisallowableStaffCosts                     or ../MTR:DisallowableCarAndTravelExpenses                     or ../MTR:DisallowableRentAndOtherPropertyCosts                     or ../MTR:DisallowableRepairAndRenewalCosts                     or ../MTR:DisallowablePhoneAndOtherOfficeCosts                     or ../MTR:DisallowableAdvertisingAndEntertainmentCosts                     or ../MTR:DisallowableBankAndLoanInterest                     or ../MTR:DisallowableOtherFinanceCharges                     or ../MTR:DisallowableDebtsWrittenOff                     or ../MTR:DisallowableAccountancyAndLegalFees                     or ../MTR:DisallowableDepreciationAndLossProfitOnSale                     or ../MTR:DisallowableOtherBusinessExpenses                   )                   or                   (math:abs((.) - (sum(../MTR:DisallowableCostOfGoods)                      + sum(../MTR:DisallowableSubcontractorCosts)                      + sum(../MTR:DisallowableStaffCosts)                      + sum(../MTR:DisallowableCarAndTravelExpenses)                      + sum(../MTR:DisallowableRentAndOtherPropertyCosts)                      + sum(../MTR:DisallowableRepairAndRenewalCosts)                      + sum(../MTR:DisallowablePhoneAndOtherOfficeCosts)                      + sum(../MTR:DisallowableAdvertisingAndEntertainmentCosts)                      + sum(../MTR:DisallowableBankAndLoanInterest)                      + sum(../MTR:DisallowableOtherFinanceCharges)                      + sum(../MTR:DisallowableDebtsWrittenOff)                      + sum(../MTR:DisallowableAccountancyAndLegalFees)                      + sum(../MTR:DisallowableDepreciationAndLossProfitOnSale)                      + sum(../MTR:DisallowableOtherBusinessExpenses))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8301</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If entry in any of [FSE32], [FSE33], [FSE34], [FSE35], [FSE36], [FSE37], [FSE38], [FSE39], [FSE40], [FSE41], [FSE42], [FSE43], [FSE44], [FSE45] then total of those boxes must equal [FSE46]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If entry in any of [FSE32], [FSE33], [FSE34], [FSE35], [FSE36], [FSE37], [FSE38], [FSE39], [FSE40], [FSE41], [FSE42], [FSE43], [FSE44], [FSE45] then total of those boxes must equal [FSE46]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M91" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M91" priority="-1"/>
  <axsl:template match="@*|node()" mode="M91" priority="-2">
    <axsl:apply-templates mode="M91" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p91-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:NetProfitLoss" mode="M92" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="( (math:abs(((sum(../MTR:BusinessIncome/MTR:Turnover) + sum(../MTR:BusinessIncome/MTR:OtherBusinessIncome) - sum(../MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses))) - ((.))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6055</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE47/FSE48] must equal the sum of [FSE15] plus [FSE16] minus [FSE31]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The sum of [FSE15] + [FSE16] minus [FSE31] must equal [FSE47/FSE48]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M92" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M92" priority="-1"/>
  <axsl:template match="@*|node()" mode="M92" priority="-2">
    <axsl:apply-templates mode="M92" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p93-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance" mode="M93" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 750000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6062</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE49] exceeds [£750,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE49] should not exceed [£750,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M93" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M93" priority="-1"/>
  <axsl:template match="@*|node()" mode="M93" priority="-2">
    <axsl:apply-templates mode="M93" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p94-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:TotalCapitalAllowances" mode="M94" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AnnualInvestmentAllowance) + sum(../MTR:AnnualAllowancesAtLowerRate) + sum(../MTR:AnnualAllowancesAtHigherRate) + sum(../MTR:RestrictedAnnualAllowances) + sum(../MTR:BusinessPremisesRenovationAllowance) + sum(../MTR:OtherCapitalAllowances) + sum(../MTR:BalancingAllowancesOnSaleOrCessation)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6056</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE57] must equal ( the sum of [FSE49], [FSE51], [FSE50], [FSE52], [FSE54], [FSE55], and [FSE56] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] is valid only if this equals ( The sum of [FSE49], [FSE51], [FSE50], [FSE52], [FSE54], [FSE55], and [FSE56] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M94" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M94" priority="-1"/>
  <axsl:template match="@*|node()" mode="M94" priority="-2">
    <axsl:apply-templates mode="M94" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p92-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances" mode="M95" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AnnualInvestmentAllowance) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8333</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE49]. Please complete [FSE57].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE49] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AnnualAllowancesAtHigherRate) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8334</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE50]. Please complete [FSE57].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE50] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AnnualAllowancesAtLowerRate) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8335</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE51]. Please complete [FSE57].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE51] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:RestrictedAnnualAllowances) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8336</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE52]. Please complete [FSE57].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE52] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BusinessPremisesRenovationAllowance) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8337</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE54]. Please complete [FSE57]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE54] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:OtherCapitalAllowances) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8338</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE55]. Please complete [FSE57].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE55] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BalancingAllowancesOnSaleOrCessation) or MTR:TotalCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8339</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE56]. Please complete [FSE57]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE57] should be present if [FSE56] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M95" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M95" priority="-1"/>
  <axsl:template match="@*|node()" mode="M95" priority="-2">
    <axsl:apply-templates mode="M95" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p96-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss" mode="M96" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses) + sum(../../MTR:CapitalAllowances/MTR:ChargesOnCessationOfBusiness) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../MTR:OwnGoodsAndServices)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6059</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE61] must equal ( the sum of [FSE46], [FSE58], [FSE59], and [FSE60] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
additions to net profit/deductions from net loss is valid if and only if this equals ( The sum of [FSE46], [FSE58], [FSE59], and [FSE60] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M96" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M96" priority="-1"/>
  <axsl:template match="@*|node()" mode="M96" priority="-2">
    <axsl:apply-templates mode="M96" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p97-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:DeductionsFromNetProfitAdditionsToNetLoss" mode="M97" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:CapitalAllowances/MTR:TotalCapitalAllowances) + sum(../MTR:NonTaxableBusinessIncome)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6065</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE63] must equal ( [FSE57] plus [FSE62] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE63] should equal ( [FSE57] plus [FSE62] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M97" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M97" priority="-1"/>
  <axsl:template match="@*|node()" mode="M97" priority="-2">
    <axsl:apply-templates mode="M97" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p98-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax" mode="M98" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((sum(../../MTR:NetProfitLoss) + sum(../MTR:AdditionsToNetProfitDeductionsFromNetLoss) - sum(../MTR:DeductionsFromNetProfitAdditionsToNetLoss))) - (number(.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6111</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE64 / FSE65] must equal the sum of [FSE47/FSE48] plus [FSE61] minus [FSE63]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The sum of [FSE47/FSE48] + [FSE61] - [FSE63] must equal [FSE64 / FSE65].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M98" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M98" priority="-1"/>
  <axsl:template match="@*|node()" mode="M98" priority="-2">
    <axsl:apply-templates mode="M98" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p99-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:DateBasisPeriodEnded" mode="M99" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="number(translate(.,'-','')) &gt;= number(translate(../MTR:DateBasisPeriodBegan,'-',''))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6217</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date cannot be earlier than [FSE66]. Please amend the entrry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FSE67] is present, then [FSE66] should be present and [FSE67] should not be earlier than [FSE66].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M99" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M99" priority="-1"/>
  <axsl:template match="@*|node()" mode="M99" priority="-2">
    <axsl:apply-templates mode="M99" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p100-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:LossBroughtForward" mode="M100" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(. &lt;= sum(../MTR:NetBusinessProfitLossForTax)) or (. &lt;= sum(../MTR:AdjustedProfitForTheYear))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6226</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">This amount exceeds the amount entered in either [FSE64 / FSE65] or [FSE73]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must not exceed the larger of [FSE64 / FSE65] or [FSE73]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M100" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M100" priority="-1"/>
  <axsl:template match="@*|node()" mode="M100" priority="-2">
    <axsl:apply-templates mode="M100" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p101-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits" mode="M101" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../MTR:AdjustedProfitForTheYear) - sum(../MTR:LossBroughtForward) + sum(../MTR:AnyOtherBusinessIncome))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6115</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE76] must equal [FSE73] minus [FSE74] plus [FSE75]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE76] should equal [FSE73] minus [FSE74] plus [FSE75]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M101" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M101" priority="-1"/>
  <axsl:template match="@*|node()" mode="M101" priority="-2">
    <axsl:apply-templates mode="M101" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p95-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss" mode="M102" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(MTR:NetBusinessProfitLossForTax) + sum(MTR:BasisPeriodAdjustment) - sum(MTR:OverlapReliefUsed))) - (0) &lt; 0.001)                 or               (MTR:AdjustedProfitForTheYear and (math:abs(((sum(MTR:NetBusinessProfitLossForTax) + sum(MTR:BasisPeriodAdjustment) - sum(MTR:OverlapReliefUsed)) + sum(MTR:AveragingAdjustment)  + sum(MTR:ChangeOfAccountingPracticeAdjustment)) - (sum(MTR:AdjustedProfitForTheYear))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8215</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE73] must equal ([FSE64 / FSE65] + [FSE68] - [FSE69] + [FSE72] +  [FSE71]) if the sum of ([FSE64 / FSE65] + [FSE68] - [FSE69]) is positive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FSE64 / FSE65] + [FSE68] - [FSE69]) is positive, then [FSE73] is mandatory and  = ([FSE64 / FSE65] + [FSE68] - [FSE69] + [FSE72] +  [FSE71])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(MTR:NetBusinessProfitLossForTax) + sum(MTR:BasisPeriodAdjustment) - sum(MTR:OverlapReliefUsed))) - (0) &gt;= 0.001)                 or               ( (sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment)) &gt; 0 and (MTR:AdjustedProfitForTheYear and (math:abs((sum(MTR:AdjustedProfitForTheYear)) - ((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment)))) &lt; 0.001)))                 or               ( (sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment)) &lt;= 0 and (sum(MTR:AdjustedProfitForTheYear) = 0))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8216</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE69]) is negative or zero. If ([FSE71] + [FSE72]) is greater than zero, the amount in box [FSE73] must equal ([FSE71] + [FSE72]) or [FSE73] must be zero or absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FSE64 / FSE65] + [FSE68] - [FSE69]) is negative or zero, then if ([FSE71] + [FSE72]) is greater than zero, then [FSE73] is mandatory and = ([FSE71] + [FSE72]); else [FSE73] must be zero or absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:NetBusinessProfitLossForTax) + sum(MTR:BasisPeriodAdjustment) - sum(MTR:OverlapReliefUsed))) - (0) &lt;= -0.001))             or           (math:abs((math:abs((sum(MTR:NetBusinessProfitLossForTax) + sum(MTR:BasisPeriodAdjustment) - sum(MTR:OverlapReliefUsed)))) - (sum(../MTR:Losses/MTR:AdjustedLossForTheYear))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8217</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE69]) is negative. Please complete box [FSE77] with the positive equivalent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FSE64 / FSE65] + [FSE68] - [FSE69]) is negative, then [FSE77] is mandatory and  = positive equivalent of ([FSE64 / FSE65] + [FSE68] - [FSE69])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M102" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M102" priority="-1"/>
  <axsl:template match="@*|node()" mode="M102" priority="-2">
    <axsl:apply-templates mode="M102" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p102-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:AdjustedLossForTheYear" mode="M103" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../../MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(../../MTR:TaxableProfitOrLoss/MTR:BasisPeriodAdjustment) - sum(../../MTR:TaxableProfitOrLoss/MTR:OverlapReliefUsed))) - (0) &lt;= -0.001)             or           (math:abs((0) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8218</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE69]) is greater than or equal to zero. The entry in box [FSE77] must equal 0 or be absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FSE64 / FSE65] + [FSE68] - [FSE69]) is greater than or equal to zero, then [FSE77] = 0 or is absent.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M103" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M103" priority="-1"/>
  <axsl:template match="@*|node()" mode="M103" priority="-2">
    <axsl:apply-templates mode="M103" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p103-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:LossOfYearSetAgainstOtherIncome" mode="M104" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:AdjustedLossForTheYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6281</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE78] exceeds the amount in box [FSE77]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE78] should not exceed [FSE77]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M104" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M104" priority="-1"/>
  <axsl:template match="@*|node()" mode="M104" priority="-2">
    <axsl:apply-templates mode="M104" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p104-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:LossToCarryBack" mode="M105" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((.)) - (sum(../MTR:AdjustedLossForTheYear) - sum(../MTR:LossOfYearSetAgainstOtherIncome)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6449</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE79] exceeds ( [FSE77] minus [FSE78]). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must not exceed [FSE77] minus [FSE78]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M105" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M105" priority="-1"/>
  <axsl:template match="@*|node()" mode="M105" priority="-2">
    <axsl:apply-templates mode="M105" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p105-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:Assets/MTR:TotalBusinessAssets" mode="M106" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:EquipmentMachineryVehicles) + sum(../MTR:OtherFixedAssets) + sum(../MTR:StockAndWorkInProgress) + sum(../MTR:TradeDebtors) + sum(../MTR:BankEtcBalances) + sum(../MTR:CashInHand) + sum(../MTR:OtherCurrentAssets)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6131</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE90] must equal ( the sum of [FSE83], [FSE84], [FSE85], [FSE86], [FSE87], [FSE88], and [FSE89] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
total business assets is valid if and only if this equals ( The sum of [FSE83], [FSE84], [FSE85], [FSE86], [FSE87], [FSE88], and [FSE89] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M106" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M106" priority="-1"/>
  <axsl:template match="@*|node()" mode="M106" priority="-2">
    <axsl:apply-templates mode="M106" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p106-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:NetBusinessAssets" mode="M107" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../MTR:Assets/MTR:TotalBusinessAssets) - (sum(../MTR:Liabilities/MTR:TradeCreditors) + sum(../MTR:Liabilities/MTR:LoansAndOverdrafts) + sum(../MTR:Liabilities/MTR:OtherLiabilities)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6142</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE94] must equal ( [FSE90] minus ( the sum of [FSE91], [FSE92], and [FSE93] ) ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE94] should equal ( [FSE90] minus ( The sum of [FSE91], [FSE92], and [FSE93] ) )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M107" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M107" priority="-1"/>
  <axsl:template match="@*|node()" mode="M107" priority="-2">
    <axsl:apply-templates mode="M107" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p107-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:CapitalAccount/MTR:NetProfitOrLoss" mode="M108" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="number(.) = sum(../../../MTR:NetProfitLoss)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6836</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount entered in box [FSE96] must equal the amount entered in [FSE47/FSE48]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must = [FSE47/FSE48]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M108" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M108" priority="-1"/>
  <axsl:template match="@*|node()" mode="M108" priority="-2">
    <axsl:apply-templates mode="M108" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p108-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalAccountBalanceAtEnd" mode="M109" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:CapitalAccountBalanceAtStart) + sum(../MTR:NetProfitOrLoss) + sum(../MTR:CapitalIntroduced)) - sum(../MTR:Drawings)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6146</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSE99] must equal ( ( the sum of [FSE95], [FSE96], and [FSE97] ) minus [FSE98] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSE99] should equal ( ( The sum of [FSE95], [FSE96], and [FSE97] ) minus [FSE98] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M109" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M109" priority="-1"/>
  <axsl:template match="@*|node()" mode="M109" priority="-2">
    <axsl:apply-templates mode="M109" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p110-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:NICs/MTR:Class2NICamount" mode="M110" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 182.85"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8342</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FSECL2] exceeds [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSECL2] is valid only if this does not exceed [£182.85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M110" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M110" priority="-1"/>
  <axsl:template match="@*|node()" mode="M110" priority="-2">
    <axsl:apply-templates mode="M110" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p109-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:NICs" mode="M111" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexception or MTR:AdjustmentToClass4NICProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8340</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [FSE100-102] is present there must be an entry in at least one of [FSE100], [FSECL2], [FSE101] or [FSE102]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FSE100-102] is present then at least one of the following should be present: [FSE100], [FSECL2], [FSE101] or [FSE102]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:PayClass2NICvoluntarily) or MTR:Class2NICamount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8341</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE100]. Please complete [FSECL2].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FSECL2] should be present if [FSE100] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M111" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M111" priority="-1"/>
  <axsl:template match="@*|node()" mode="M111" priority="-2">
    <axsl:apply-templates mode="M111" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p82-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F" mode="M112" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BusinessDetails/MTR:DateAccountingPeriodStarts) or MTR:BusinessDetails/MTR:DateAccountingPeriodEnds"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6031</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE8]. Please complete [FSE9].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>date accounting period ends should be present if [FSE8]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BusinessExpenses/MTR:TotalExpenses/MTR:CostOfGoods or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:SubcontractorCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:WagesSalariesAndStaffCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:CarVanAndTravelExpenses or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:RentAndOtherPropertyCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:RepairAndRenewalCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:PhoneAndOtherOfficeCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:AdvertisingAndEntertainmentCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:BankAndLoanInterest or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:OtherFinanceCharges or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:DebtsWrittenOff or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:AccountancyAndLegalFees or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:DepreciationAndLossProfitOnSale or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:OtherBusinessExpenses) or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6032</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE17] or [FSE18] or [FSE19] or [FSE20] or [FSE21] or [FSE22] or [FSE23] or [FSE24] or [FSE25] or [FSE26] or [FSE27] or [FSE28] or [FSE29] or [FSE30]. Please complete box [FSE31].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total expenses should be present if [FSE17] or [FSE18] or [FSE19] or [FSE20] or [FSE21] or [FSE22] or [FSE23] or [FSE24] or [FSE25] or [FSE26] or [FSE27] or [FSE28] or [FSE29] or [FSE30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableCostOfGoods or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableSubcontractorCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableStaffCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableCarAndTravelExpenses or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableRentAndOtherPropertyCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableRepairAndRenewalCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowablePhoneAndOtherOfficeCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableAdvertisingAndEntertainmentCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableBankAndLoanInterest or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableOtherFinanceCharges or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableDebtsWrittenOff or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableAccountancyAndLegalFees or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableDepreciationAndLossProfitOnSale or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableOtherBusinessExpenses) or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6033</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE32] or [FSE33] or [FSE34] or [FSE35] or [FSE36] or [FSE37] or [FSE38] or [FSE39] or [FSE40] or [FSE41] or [FSE42] or [FSE43] or [FSE44] or [FSE45]. Please complete box [FSE46].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total disallowable expenses should be present if [FSE32] or [FSE33] or [FSE34] or [FSE35] or [FSE36] or [FSE37] or [FSE38] or [FSE39] or [FSE40] or [FSE41] or [FSE42] or [FSE43] or [FSE44] or [FSE45]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((sum(MTR:BusinessIncome/MTR:Turnover) + sum(MTR:BusinessIncome/MTR:OtherBusinessIncome)) - sum(MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses)) - (0)) &lt; 0.001) or MTR:NetProfitLoss"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6034</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [FSE15] plus [FSE16] ) minus [FSE31] ) is non-zero. Please complete [FSE47/FSE48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>net profit should be present if ( ( [FSE15] plus [FSE16] ) minus [FSE31] ) is non-zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses or MTR:CapitalAllowances/MTR:ChargesOnCessationOfBusiness or MTR:CapitalAllowances/MTR:TotalBalancingCharges or MTR:TaxableProfitOrLoss/MTR:OwnGoodsAndServices) or MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6037</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE46] or [FSE58] or [FSE59] or [FSE60]. Please complete box [FSE61].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
additions to net profit/deductions from net loss should be present if [FSE46] or [FSE58] or [FSE59] or [FSE60]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:CapitalAllowances/MTR:TotalCapitalAllowances or MTR:TaxableProfitOrLoss/MTR:NonTaxableBusinessIncome) or MTR:TaxableProfitOrLoss/MTR:DeductionsFromNetProfitAdditionsToNetLoss"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6042</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE57] or [FSE62]. Please complete box [FSE63].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>deductions from net profit/additions to net loss should be present if [FSE57] or [FSE62]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((sum(MTR:NetProfitLoss) + sum(MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss)) - sum(MTR:TaxableProfitOrLoss/MTR:DeductionsFromNetProfitAdditionsToNetLoss)) - (0)) &lt; 0.001) or MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6044</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [FSE47/FSE48] plus [FSE61] ) minus ( [FSE63] ) ) is non-zero. Please complete [FSE64 / FSE65].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Net business profit for tax should be present if ( ( [FSE47/FSE48] plus [FSE61] ) minus ( [FSE63] ) ) is non-zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(( sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear) &gt; 0 ) or ( sum(MTR:TaxableProfitOrLoss/MTR:LossBroughtForward) &gt; 0 ) or ( sum(MTR:TaxableProfitOrLoss/MTR:AnyOtherBusinessIncome) &gt; 0 )) or MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6045</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in any of the boxes [FSE73] or [FSE74] or [FSE75] exceeds 0. Please complete box [FSE76].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total taxable business profits should be present if any of [FSE73] or [FSE74] or [FSE75] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BalanceSheet/MTR:Assets/MTR:EquipmentMachineryVehicles or MTR:BalanceSheet/MTR:Assets/MTR:OtherFixedAssets or MTR:BalanceSheet/MTR:Assets/MTR:StockAndWorkInProgress or MTR:BalanceSheet/MTR:Assets/MTR:TradeDebtors or MTR:BalanceSheet/MTR:Assets/MTR:BankEtcBalances or MTR:BalanceSheet/MTR:Assets/MTR:CashInHand or MTR:BalanceSheet/MTR:Assets/MTR:OtherCurrentAssets) or MTR:BalanceSheet/MTR:Assets/MTR:TotalBusinessAssets"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6048</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE83] or [FSE84] or [FSE85] or [FSE86] or [FSE87] or [FSE88] or [FSE89]. Please complete box [FSE90].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
total business assets should be present if [FSE83] or [FSE84] or [FSE85] or [FSE86] or [FSE87] or [FSE88] or [FSE89]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BalanceSheet/MTR:Assets/MTR:TotalBusinessAssets or MTR:BalanceSheet/MTR:Liabilities/MTR:TradeCreditors or MTR:BalanceSheet/MTR:Liabilities/MTR:LoansAndOverdrafts or MTR:BalanceSheet/MTR:Liabilities/MTR:OtherLiabilities) or MTR:BalanceSheet/MTR:NetBusinessAssets"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6057</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE90] or [FSE91] or [FSE92] or [FSE93]. Please complete box [FSE94].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>

net business assets should be present if [FSE90] or [FSE91] or [FSE92] or [FSE93]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalAccountBalanceAtStart or MTR:BalanceSheet/MTR:CapitalAccount/MTR:NetProfitOrLoss or MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalIntroduced or MTR:BalanceSheet/MTR:CapitalAccount/MTR:Drawings) or MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalAccountBalanceAtEnd"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6058</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FSE95] or [FSE96] or [FSE97] or [FSE98]. Please complete box [FSE99].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>

capital account balance at end should be present if [FSE95] or [FSE96] or [FSE97] or [FSE98]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M112" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M112" priority="-1"/>
  <axsl:template match="@*|node()" mode="M112" priority="-2">
    <axsl:apply-templates mode="M112" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p112-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:DateBusinessStarted" mode="M113" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6433</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSE5] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M113" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M113" priority="-1"/>
  <axsl:template match="@*|node()" mode="M113" priority="-2">
    <axsl:apply-templates mode="M113" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p113-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:DateBusinessCeased" mode="M114" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6433</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSE6] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(number(translate(.,'-','')) &gt;= number(translate(../MTR:DateBusinessStarted,'-',''))) or not (../MTR:DateBusinessStarted)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6147</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date cannot be earlier than [SSE5]. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If present must be the same as or later than [SSE5]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M114" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M114" priority="-1"/>
  <axsl:template match="@*|node()" mode="M114" priority="-2">
    <axsl:apply-templates mode="M114" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p114-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:CashBasis" mode="M115" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../../MTR:ProfitsLossesNICsAndCIS/MTR:LossOfYearSetAgainstOtherIncome) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8302</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [SSE8] is present, then [SSE33] must be zero or absent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE8] is present, then [SSE33] must be zero or absent.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M115" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M115" priority="-1"/>
  <axsl:template match="@*|node()" mode="M115" priority="-2">
    <axsl:apply-templates mode="M115" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p115-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessIncome/MTR:Turnover" mode="M116" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:BusinessDetails/MTR:DateBusinessStarted or ../../MTR:BusinessDetails/MTR:DateBusinessCeased                 or               ((.) - (82000) &lt;= -0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6235</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE9] must be below [£82,000] as [SSE5] and [SSE6] are both absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE5] and [SSE6] are both absent, amount must be below [£82,000].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../MTR:BusinessDetails/MTR:DateBusinessStarted) or ../../MTR:BusinessDetails/MTR:DateBusinessCeased                 or               ((.) - 82000 * ((round((date:seconds(normalize-space('2016-04-05')) - date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessStarted))) div 86400 ) + 1) div (round( date:seconds(date:difference('2015-04-06', '2016-04-05')) div 86400 ) + 1))) &lt; -0.00000001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6236</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As there is an entry in [SSE5] but [SSE6] is absent, the amount in box [SSE9] must be below ([£82,000] x number of days / (365 or 366) ) where number of days equals the number of days from [SSE5]  to [5 April 2016] inclusive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE5] present but [SSE6] is absent, amount must be below ([£82,000] x no of days / (365 or 366) ) where no of days = no of days from ( [SSE5]  to [5 April 2016] inclusive )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:BusinessDetails/MTR:DateBusinessStarted or not(../../MTR:BusinessDetails/MTR:DateBusinessCeased)                 or               ((.) - 82000 * ((round((date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessCeased)) - date:seconds(normalize-space('2015-04-06'))) div 86400 ) + 1) div (round( date:seconds(date:difference('2015-04-06', '2016-04-05')) div 86400 ) + 1))) &lt; -0.00000001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6237</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As there is an entry in [SSE6] but [SSE5] is absent, the amount in box [SSE9] must be below ( [£82,000] x number of days / (365 or 366) ) where number of days equals the number of days from [6 April 2015] to [SSE6] inclusive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE6] is present but [SSE5] is absent, amount must be below ( [£82,000] x no of days / (365 or 366) ) where no of days = no of days from ( [6 April 2015] to [SSE6] inclusive )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../MTR:BusinessDetails/MTR:DateBusinessStarted) or not(../../MTR:BusinessDetails/MTR:DateBusinessCeased)                 or               (((.) -  (82000 * ((round((date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessCeased)) - date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessStarted))) div 86400 ) + 1) div (round( date:seconds(date:difference('2015-04-06', '2016-04-05')) div 86400 ) + 1)))) &lt; -0.00000001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6238</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As there is an entry in both [SSE5] and [SSE6], the amount in box [SSE9] must be below ( [£82,000] x number of days / (365 or 366) ) where number of days equals the number of days from [SSE5] to [SSE6] inclusive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE5] and [SSE6] are both present, amount must be below ( [£82,000] x no of days / (365 or 366) ) where the no of days = no of days from [SSE5] to [SSE6] inclusive</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M116" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M116" priority="-1"/>
  <axsl:template match="@*|node()" mode="M116" priority="-2">
    <axsl:apply-templates mode="M116" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p116-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses" mode="M117" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(   . &lt;= 0 ) or (   sum(../../MTR:BusinessIncome/MTR:Turnover) &lt; 82000 ) or (     (math:abs((number(.)) - ((sum(../MTR:CostOfGoods) +                            sum(../MTR:CarVanAndTravelExpenses) +                            sum(../MTR:WagesSalariesAndStaffCosts) +                            sum(../MTR:RentAndOtherPropertyCosts) +                            sum(../MTR:RepairAndRenewalCosts) +                            sum(../MTR:AccountancyAndLegalFees) +                            sum(../MTR:InterestAndFinanceCharges) +                            sum(../MTR:PhoneAndOtherOfficeCosts) +                            sum(../MTR:OtherAllowableBusinessExpenses)))) &lt; 0.001) )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6163</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As the amount in box [SSE20] is greater than zero and [SSE9] is equal to or greater than [£82,000] there must be an entry in at least one of [SSE11] to [SSE19] and [SSE20] must equal the total of those boxes. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE20] is present and greater than zero and [SSE9] is &gt;= [£82,000] there must be an entry in at least one of [SSE11] to [SSE19] and [SSE20] must equal the total of those boxes.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M117" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M117" priority="-1"/>
  <axsl:template match="@*|node()" mode="M117" priority="-2">
    <axsl:apply-templates mode="M117" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p117-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:NetProfitOrLoss" mode="M118" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((number(.)) - ((sum(../MTR:BusinessIncome/MTR:Turnover) + sum(../MTR:BusinessIncome/MTR:OtherBusinessIncome) - sum(../MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6176</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in [SSE21/SSE22] must equal the sum of [SSE9] plus [SSE10] minus [SSE20]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The sum of [SSE9] + [SSE10] - [SSE20] must equal [SSE21/SSE22]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M118" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M118" priority="-1"/>
  <axsl:template match="@*|node()" mode="M118" priority="-2">
    <axsl:apply-templates mode="M118" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p118-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance" mode="M119" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 750000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6070</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE23] exceeds [£750,000]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSE23] must not exceed [£750,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M119" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M119" priority="-1"/>
  <axsl:template match="@*|node()" mode="M119" priority="-2">
    <axsl:apply-templates mode="M119" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p119-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:TaxableProfits/MTR:NetBusinessProfitForTax" mode="M120" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../MTR:OwnGoodsAndServices) - (sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances))) - (0) &lt; 0.001)  or  (math:abs((number(.)) - (sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../MTR:OwnGoodsAndServices) - (sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6177</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE28] must equal the sum of ( ( [SSE21/SSE22] plus [SSE26] plus [SSE27] ) minus ( [SSE23] plus [SSE24] plus [SSE25] ) ) if positive. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Where sum of [SSE21/SSE22] + [SSE26] + [SSE27] minus ( [SSE23] + [SSE24] + [SSE25] is positive [SSE28] must equal that positive amount</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M120" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M120" priority="-1"/>
  <axsl:template match="@*|node()" mode="M120" priority="-2">
    <axsl:apply-templates mode="M120" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p120-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:TaxableProfits/MTR:LossBroughtForward" mode="M121" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:NetBusinessProfitForTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6282</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE29] exceeds the amount in box [SSE28]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSE29] should not exceed [SSE28]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M121" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M121" priority="-1"/>
  <axsl:template match="@*|node()" mode="M121" priority="-2">
    <axsl:apply-templates mode="M121" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p121-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits" mode="M122" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (((sum(../../MTR:TaxableProfits/MTR:NetBusinessProfitForTax) + sum(../../MTR:TaxableProfits/MTR:AnyOtherBusinessIncome)) - sum(../../MTR:TaxableProfits/MTR:LossBroughtForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6178</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE31] must equal ( ( [SSE28] plus [SSE30] ) minus [SSE29] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SSE31] is present, it should equal ( ( [SSE28] plus [SSE30] ) minus [SSE29] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M122" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M122" priority="-1"/>
  <axsl:template match="@*|node()" mode="M122" priority="-2">
    <axsl:apply-templates mode="M122" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p122-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:NetBusinessLossForTax" mode="M123" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances) - ( sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../../MTR:TaxableProfits/MTR:OwnGoodsAndServices) )) - (0) &lt;= -0.001) or (math:abs((.) - (sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances) - ( sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../../MTR:TaxableProfits/MTR:OwnGoodsAndServices) ))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6183</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE32] must equal [SSE23] plus [SSE24] plus [SSE25] minus ([SSE21/SSE22] plus [SSE26] plus [SSE27]) if positive or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Where the sum of [SSE23] + [SSE24] + [SSE25] - ([SSE21/SSE22] + [SSE26] + [SSE27]) is positive or zero [SSE32] must equal that sum</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M123" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M123" priority="-1"/>
  <axsl:template match="@*|node()" mode="M123" priority="-2">
    <axsl:apply-templates mode="M123" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p123-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:LossOfYearSetAgainstOtherIncome" mode="M124" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:NetBusinessLossForTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6224</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE33] exceeds the amount in box [SSE32]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSE33] must not exceed [SSE32]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M124" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M124" priority="-1"/>
  <axsl:template match="@*|node()" mode="M124" priority="-2">
    <axsl:apply-templates mode="M124" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p124-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:LossToCarryBack" mode="M125" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (sum(../MTR:NetBusinessLossForTax) - sum(../MTR:LossOfYearSetAgainstOtherIncome)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6510</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSE34] exceeds [SSE32] minus [SSE33]. Please check</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSE34] must not be greater than [SSE32] - [SSE33]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M125" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M125" priority="-1"/>
  <axsl:template match="@*|node()" mode="M125" priority="-2">
    <axsl:apply-templates mode="M125" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p125-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:PayClass2NICvoluntarily" mode="M126" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Class2NICamount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8344</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [SSE36]. Please complete [SSECL2]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSECL2] should be present if [SSE36] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M126" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M126" priority="-1"/>
  <axsl:template match="@*|node()" mode="M126" priority="-2">
    <axsl:apply-templates mode="M126" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p126-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class2NICamount" mode="M127" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 182.85"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8345</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SSECL2] exceeds [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SSECL2] is valid only if this does not exceed [£182.85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M127" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M127" priority="-1"/>
  <axsl:template match="@*|node()" mode="M127" priority="-2">
    <axsl:apply-templates mode="M127" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p111-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S" mode="M128" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AllowableBusinessExpenses/MTR:CostOfGoods or MTR:AllowableBusinessExpenses/MTR:CarVanAndTravelExpenses or MTR:AllowableBusinessExpenses/MTR:WagesSalariesAndStaffCosts or MTR:AllowableBusinessExpenses/MTR:RentAndOtherPropertyCosts or MTR:AllowableBusinessExpenses/MTR:RepairAndRenewalCosts or MTR:AllowableBusinessExpenses/MTR:AccountancyAndLegalFees or MTR:AllowableBusinessExpenses/MTR:InterestAndFinanceCharges or MTR:AllowableBusinessExpenses/MTR:PhoneAndOtherOfficeCosts or MTR:AllowableBusinessExpenses/MTR:OtherAllowableBusinessExpenses) or MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6063</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [SSE11] or [SSE12] or [SSE13] or [SSE14] or [SSE15] or [SSE16] or [SSE17] or [SSE18] or [SSE19]. Please complete box [SSE20].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total allowable expenses should be present if [SSE11] or [SSE12] or [SSE13] or [SSE14] or [SSE15] or [SSE16] or [SSE17] or [SSE18] or [SSE19]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((((sum(MTR:BusinessIncome/MTR:Turnover) + sum(MTR:BusinessIncome/MTR:OtherBusinessIncome)) - sum(MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses))) - (0)) &lt; 0.001) or MTR:NetProfitOrLoss"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6066</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [SSE9] plus [SSE10] ) minus [SSE20] ) is non-zero. Please complete box [SSE21/SSE22].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Net profit should be present if ( ( [SSE9] plus [SSE10] ) minus [SSE20] ) is non-zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:NetProfitOrLoss) + sum(MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(MTR:TaxableProfits/MTR:OwnGoodsAndServices)) - (sum(MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(MTR:CapitalAllowances/MTR:OtherCapitalAllowances)))) - (0) &gt;= 0.001)) or MTR:TaxableProfits/MTR:NetBusinessProfitForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6067</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [SSE21/SSE22], [SSE26], and [SSE27] ) minus ( [SSE23], [SSE24], and [SSE25] ) ) exceeds 0. Please complete box [SSE28].
</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>

net business profit for tax should be present if ( ( The sum of [SSE21/SSE22], [SSE26], and [SSE27] ) minus ( The sum of [SSE23], [SSE24], and [SSE25] ) ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:TaxableProfits/MTR:NetBusinessProfitForTax) + sum(MTR:TaxableProfits/MTR:AnyOtherBusinessIncome)) - sum(MTR:TaxableProfits/MTR:LossBroughtForward))) - (0) &gt;= 0.001)) or MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6068</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [SSE28] plus [SSE30] ) minus [SSE29] ) exceeds 0. Please complete box [SSE31].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total taxable business profits should be present if ( ( [SSE28] plus [SSE30] ) minus [SSE29] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(MTR:CapitalAllowances/MTR:OtherCapitalAllowances)) - (sum(MTR:NetProfitOrLoss) + sum(MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(MTR:TaxableProfits/MTR:OwnGoodsAndServices)))) - (0) &gt;= 0.001)) or MTR:ProfitsLossesNICsAndCIS/MTR:NetBusinessLossForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6069</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [SSE23], [SSE24], and [SSE25] ) minus ( [SSE21/SSE22], [SSE26], and [SSE27] ) ) exceeds 0. Please complete box [SSE32].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Loss for the year should be present if ( ( The sum of [SSE23], [SSE24], and [SSE25] ) minus ( The sum of [SSE21/SSE22], [SSE26], and [SSE27] ) ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M128" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M128" priority="-1"/>
  <axsl:template match="@*|node()" mode="M128" priority="-2">
    <axsl:apply-templates mode="M128" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p128-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKInterest/MTR:TaxTakenOff" mode="M129" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt; sum(../MTR:TaxedBankEtcInterest)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6194</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN4] must be less than the amount in box [LUN3]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN4] should be less than [LUN3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M129" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M129" priority="-1"/>
  <axsl:template match="@*|node()" mode="M129" priority="-2">
    <axsl:apply-templates mode="M129" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p129-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff" mode="M130" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:BankEtcAndGiltUntaxedInterest) + sum(../MTR:AccruedIncomeSchemeAggregateAmount) + sum(../MTR:TaxedBankEtcInterest) + sum(../MTR:TaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6531</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN5] must equal ( the sum of [LUN1], [LUN2], [LUN3], and [LUN4] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN5] should equal ( The sum of [LUN1], [LUN2], [LUN3], and [LUN4] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M130" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M130" priority="-1"/>
  <axsl:template match="@*|node()" mode="M130" priority="-2">
    <axsl:apply-templates mode="M130" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p130-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKDividends/MTR:StockDividendsTaxCredit" mode="M131" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:StockDividendsAmountReceived)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6234</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN7] exceeds the amount in box [LUN6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN7] should not exceed [LUN6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M131" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M131" priority="-1"/>
  <axsl:template match="@*|node()" mode="M131" priority="-2">
    <axsl:apply-templates mode="M131" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p131-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKDividends/MTR:OtherDistributionsTaxCredit" mode="M132" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:OtherDistributionsAmountReceived)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6265</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN10] exceeds the amount in box [LUN9]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN10] should not exceed [LUN9]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M132" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M132" priority="-1"/>
  <axsl:template match="@*|node()" mode="M132" priority="-2">
    <axsl:apply-templates mode="M132" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p132-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions" mode="M133" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:StockDividendsAmountReceived) + sum(../MTR:StockDividendsTaxCredit) + sum(../MTR:NonQualifyingDistributionsAmountReceived) + sum(../MTR:OtherDistributionsAmountReceived) + sum(../MTR:OtherDistributionsTaxCredit)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6279</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN11] must equal ( the sum of [LUN6], [LUN7], [LUN8], [LUN9], and [LUN10] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN11] should equal ( The sum of [LUN6], [LUN7], [LUN8], [LUN9], and [LUN10] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M133" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M133" priority="-1"/>
  <axsl:template match="@*|node()" mode="M133" priority="-2">
    <axsl:apply-templates mode="M133" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p133-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome" mode="M134" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:Interest/MTR:ForeignInterestEtcAmount) + sum(../../MTR:Interest/MTR:ForeignTaxDeducted) + sum(../../MTR:Interest/MTR:UKTaxDeducted) + sum(../MTR:NonUKDividendsAmount) + sum(../MTR:ForeignTaxDeducted) + sum(../MTR:UKTaxDeducted)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6299</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN18] must equal ( the sum of [LUN12], [LUN13], [LUN14], [LUN15], [LUN16], and [LUN17] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN18] should equal ( The sum of [LUN12], [LUN13], [LUN14], [LUN15], [LUN16], and [LUN17] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M134" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M134" priority="-1"/>
  <axsl:template match="@*|node()" mode="M134" priority="-2">
    <axsl:apply-templates mode="M134" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p134-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AmountNonQualifyingForUKTaxCredit" mode="M135" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:ForeignIncome/MTR:Dividends/MTR:NonUKDividendsAmount) + sum(../MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted) + sum(../MTR:ForeignIncome/MTR:Dividends/MTR:UKTaxDeducted))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8208</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN19] exceeds ( the sum of [LUN15], [LUN16], and [LUN17] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN19] is valid if and only if this does not exceed ( The sum of [LUN15], [LUN16], and [LUN17] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M135" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M135" priority="-1"/>
  <axsl:template match="@*|node()" mode="M135" priority="-2">
    <axsl:apply-templates mode="M135" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p135-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:AggregateSyndicateProfits" mode="M136" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalOtherLloydsReceipts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6240</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN20]. Please complete box [LUN26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] is mandatory if [LUN20]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M136" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M136" priority="-1"/>
  <axsl:template match="@*|node()" mode="M136" priority="-2">
    <axsl:apply-templates mode="M136" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p136-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:SpecialReserveFundNetWithdrawalRelease" mode="M137" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalOtherLloydsReceipts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6241</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN21]. Please complete box [LUN26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] is mandatory if [LUN21]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M137" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M137" priority="-1"/>
  <axsl:template match="@*|node()" mode="M137" priority="-2">
    <axsl:apply-templates mode="M137" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p137-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:StopLossRecoveries" mode="M138" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalOtherLloydsReceipts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6242</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN22]. Please complete box [LUN26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] is mandatory if [LUN22]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M138" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M138" priority="-1"/>
  <axsl:template match="@*|node()" mode="M138" priority="-2">
    <axsl:apply-templates mode="M138" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p138-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:CompensationReceipts" mode="M139" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalOtherLloydsReceipts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6244</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN23]. Please complete box [LUN26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] is mandatory if [LUN23]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M139" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M139" priority="-1"/>
  <axsl:template match="@*|node()" mode="M139" priority="-2">
    <axsl:apply-templates mode="M139" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p139-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:RepaymentOfForeignTaxDeduction" mode="M140" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalOtherLloydsReceipts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6245</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN24]. Please complete box [LUN26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] is mandatory if [LUN24]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M140" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M140" priority="-1"/>
  <axsl:template match="@*|node()" mode="M140" priority="-2">
    <axsl:apply-templates mode="M140" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p140-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:OtherNonsyndicateIncome" mode="M141" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalOtherLloydsReceipts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6246</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN25]. Please complete box [LUN26].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] is mandatory if [LUN25]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M141" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M141" priority="-1"/>
  <axsl:template match="@*|node()" mode="M141" priority="-2">
    <axsl:apply-templates mode="M141" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p141-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:TotalOtherLloydsReceipts" mode="M142" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AggregateSyndicateProfits) + sum(../MTR:SpecialReserveFundNetWithdrawalRelease) + sum(../MTR:StopLossRecoveries) + sum(../MTR:CompensationReceipts) + sum(../MTR:RepaymentOfForeignTaxDeduction) + sum(../MTR:OtherNonsyndicateIncome)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6247</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN26] must equal ( the sum of [LUN20], [LUN21], [LUN22], [LUN23], [LUN24], and [LUN25] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN26] should equal ( The sum of [LUN20], [LUN21], [LUN22], [LUN23], [LUN24], and [LUN25] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M142" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M142" priority="-1"/>
  <axsl:template match="@*|node()" mode="M142" priority="-2">
    <axsl:apply-templates mode="M142" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p142-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TotalLloydsIncome" mode="M143" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff) + sum(../MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions) + sum(../MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome) + sum(../MTR:OtherReceipts/MTR:TotalOtherLloydsReceipts)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6301</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN27] must equal ( the sum of [LUN5], [LUN11], [LUN18], and [LUN26] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN27] should equal ( The sum of [LUN5], [LUN11], [LUN18], and [LUN26] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M143" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M143" priority="-1"/>
  <axsl:template match="@*|node()" mode="M143" priority="-2">
    <axsl:apply-templates mode="M143" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p143-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesAndExpenses/MTR:AggregateSyndicateLosses" mode="M144" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../MTR:OtherReceipts/MTR:AggregateSyndicateProfits)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6838</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [LUN29] is completed, box [LUN20] must not be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If aggregate syndicate losses is present the following should be true: not ( [LUN20] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M144" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M144" priority="-1"/>
  <axsl:template match="@*|node()" mode="M144" priority="-2">
    <axsl:apply-templates mode="M144" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p144-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses" mode="M145" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AggregateSyndicateLosses) + sum(../MTR:SpecialReserveFundNetTransfer) + sum(../MTR:StopLossPremiumsPaid) + sum(../MTR:PersonalQuotaShareAndExeatPremiums) + sum(../MTR:EstateProtectionPlanPremiums) + sum(../MTR:UnderwritingLoanInterest) + sum(../MTR:LloydsMembersAssociationExpenses) + sum(../MTR:MembersAgentProfitCommissionAndSalaries) + sum(../MTR:BankGuaranteelettersOfCreditFees) + sum(../MTR:AccountancyFees) + sum(../MTR:OtherLloydsExpenses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6326</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN40] must equal ( the sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN40] should equal ( The sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M145" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M145" priority="-1"/>
  <axsl:template match="@*|node()" mode="M145" priority="-2">
    <axsl:apply-templates mode="M145" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p145-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ProfitAmount" mode="M146" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableProfits/MTR:TotalTaxableProfits or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6248</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN41] greater than 0. Please complete box [LUN52].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN52] mandatory if [LUN41] &gt; 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - ((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses)))) &lt; 0.001) or ((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses)) - (0) &lt;= -0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6332</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN41] must equal [LUN27] minus [LUN40] if zero or positive. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN27] minus [LUN40] is zero or positive then[LUN41] must equal the result.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../MTR:TaxableProfits/MTR:ProfitAmount)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6187</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN41] must equal the amount in box [LUN49]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN41] should equal [LUN49]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M146" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M146" priority="-1"/>
  <axsl:template match="@*|node()" mode="M146" priority="-2">
    <axsl:apply-templates mode="M146" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p146-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossAmount" mode="M147" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6334</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [LUN42] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>loss amount should not be present if ( [LUN27] minus [LUN40] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses)) - (0) &gt; -0.001)               or               (math:abs((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses) + (.)) - (0)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6532</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN42] must equal the positive equivalent of  [LUN27] minus [LUN40] if negative. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN27] minus [LUN40] is negative then [LUN42] must equal the positive equivalent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M147" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M147" priority="-1"/>
  <axsl:template match="@*|node()" mode="M147" priority="-2">
    <axsl:apply-templates mode="M147" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p147-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:ForeignTaxOnPersonalFundIncome" mode="M148" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalForeignTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6283</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN43]. Please complete box [LUN48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN48] is mandatory if [LUN43] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:ForeignIncome/MTR:Interest/MTR:ForeignTaxDeducted) + sum(../../MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6385</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN43] must equal ( [LUN13] plus [LUN16] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN43] should equal ( [LUN13] plus [LUN16] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M148" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M148" priority="-1"/>
  <axsl:template match="@*|node()" mode="M148" priority="-2">
    <axsl:apply-templates mode="M148" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p148-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:USIncomeTaxPaid" mode="M149" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalForeignTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6284</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN44]. Please complete box [LUN48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN48] is mandatory if [LUN44] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M149" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M149" priority="-1"/>
  <axsl:template match="@*|node()" mode="M149" priority="-2">
    <axsl:apply-templates mode="M149" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p149-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:CanadianTaxPaid" mode="M150" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalForeignTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6285</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN45]. Please complete box [LUN48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN48] is mandatory if [LUN45] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M150" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M150" priority="-1"/>
  <axsl:template match="@*|node()" mode="M150" priority="-2">
    <axsl:apply-templates mode="M150" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p150-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:SyndicateForeignTax" mode="M151" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalForeignTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6287</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN46]. Please complete box [LUN48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN48] is mandatory if [LUN46] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M151" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M151" priority="-1"/>
  <axsl:template match="@*|node()" mode="M151" priority="-2">
    <axsl:apply-templates mode="M151" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p151-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:AdditionalPaymentsOfForeignTax" mode="M152" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalForeignTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6288</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN47]. Please complete box [LUN48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN48] is mandatory if [LUN47] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M152" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M152" priority="-1"/>
  <axsl:template match="@*|node()" mode="M152" priority="-2">
    <axsl:apply-templates mode="M152" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p152-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:TotalForeignTax" mode="M153" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:ForeignTaxOnPersonalFundIncome) + sum(../MTR:USIncomeTaxPaid) + sum(../MTR:CanadianTaxPaid) + sum(../MTR:SyndicateForeignTax) + sum(../MTR:AdditionalPaymentsOfForeignTax)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6289</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box  [LUN48] must equal (the sum of  [LUN43], [LUN44], [LUN45], [LUN46], and [LUN47] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN48] should equal ( The sum of [LUN43], [LUN44], [LUN45], [LUN46], and [LUN47] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M153" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M153" priority="-1"/>
  <axsl:template match="@*|node()" mode="M153" priority="-2">
    <axsl:apply-templates mode="M153" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p153-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:ProfitAmount" mode="M154" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../MTR:ProfitAmount)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6087</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN49] must equal the amount in box [LUN41]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN49] should equal [LUN41]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M154" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M154" priority="-1"/>
  <axsl:template match="@*|node()" mode="M154" priority="-2">
    <axsl:apply-templates mode="M154" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p154-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:ForeignTaxClaimedAsDeduction" mode="M155" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalTaxableProfits or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6249</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN50] greater than 0. Please complete box [LUN52].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN52] mandatory if [LUN50] &gt; 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(. &lt;= 0) or (sum(../../MTR:ProfitAmount) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6534</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [LUN50] completed with an entry greater than zero, box [LUN41] must also be completed and greater than zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN50] is present and greater than zero, [LUN41] must be present and greater than zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M155" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M155" priority="-1"/>
  <axsl:template match="@*|node()" mode="M155" priority="-2">
    <axsl:apply-templates mode="M155" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p155-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:UnusedLossesBroughtForward" mode="M156" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalTaxableProfits or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6251</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN51] greater than 0. Please complete box [LUN52].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN52] mandatory if [LUN51] &gt; 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(. &lt; 0) or (sum(../../MTR:ProfitAmount) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6535</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [LUN51] completed with an entry greater than zero, box [LUN41] must also be completed and greater than zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN51] is present and greater than zero, [LUN41] must be present and greater than zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M156" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M156" priority="-1"/>
  <axsl:template match="@*|node()" mode="M156" priority="-2">
    <axsl:apply-templates mode="M156" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p156-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:TotalTaxableProfits" mode="M157" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../MTR:ProfitAmount) - ( sum(../MTR:ForeignTaxClaimedAsDeduction) + sum(../MTR:UnusedLossesBroughtForward) )) - (0) &lt;= -0.001) or (math:abs((.) - (sum(../../MTR:ProfitAmount) - ( sum(../MTR:ForeignTaxClaimedAsDeduction) + sum(../MTR:UnusedLossesBroughtForward) ))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6290</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN52] must equal the sum of [LUN41] minus ( [LUN50] plus [LUN51] ) if positive or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If the sum of [LUN41] - ( [LUN50] + [LUN51] ) is positive or zero then [LUN52] must equal that sum</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M157" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M157" priority="-1"/>
  <axsl:template match="@*|node()" mode="M157" priority="-2">
    <axsl:apply-templates mode="M157" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p157-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossAmount" mode="M158" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(../../MTR:TotalLloydsIncome) - sum(../../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6393</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [LUN53] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>loss amount should not be present if ( [LUN27] minus [LUN40] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../MTR:LossAmount)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6402</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN53] must equal [LUN42]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN53] should equal [LUN42]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M158" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M158" priority="-1"/>
  <axsl:template match="@*|node()" mode="M158" priority="-2">
    <axsl:apply-templates mode="M158" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p158-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:ForeignTaxClaimedAsDeduction" mode="M159" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(../../MTR:LossAmount) &gt; 0) or (.) &lt;= sum(../../MTR:ForeignTax/MTR:TotalForeignTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8209</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN42] greater than zero. The amount in box [LUN54] must be less than or equal to [LUN48]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN42] is present and greater than zero, [LUN54] must be less than or equal to [LUN48].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) &lt;= 0) or (sum(../../MTR:LossAmount) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6574</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry greater than zero in box [LUN54] therefore an entry greater than zero must be present in [LUN42]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN54] is present and greater than zero, [LUN42] must be present and greater than zero.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(../../MTR:TotalLloydsIncome) - sum(../../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6406</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [LUN54] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>foreign tax claimed as deduction should not be present if ( [LUN27] minus [LUN40] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M159" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M159" priority="-1"/>
  <axsl:template match="@*|node()" mode="M159" priority="-2">
    <axsl:apply-templates mode="M159" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p159-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossForTheYear" mode="M160" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:LossAmount) + sum(../MTR:ForeignTaxClaimedAsDeduction)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6410</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN55] must equal ( [LUN53] plus [LUN54] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN55] should equal ( [LUN53] plus [LUN54] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M160" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M160" priority="-1"/>
  <axsl:template match="@*|node()" mode="M160" priority="-2">
    <axsl:apply-templates mode="M160" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p160-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossOffsetAgainstOtherIncome" mode="M161" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:LossForTheYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6575</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN56] exceeds the amount in box [LUN55]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN56] should not exceed [LUN55]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M161" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M161" priority="-1"/>
  <axsl:template match="@*|node()" mode="M161" priority="-2">
    <axsl:apply-templates mode="M161" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p161-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossCarriedBack" mode="M162" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:LossForTheYear) - sum(../MTR:LossOffsetAgainstOtherIncome))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6583</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN57] exceeds ( [LUN55] minus [LUN56] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN57] should not exceed ( [LUN55] minus [LUN56] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M162" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M162" priority="-1"/>
  <axsl:template match="@*|node()" mode="M162" priority="-2">
    <axsl:apply-templates mode="M162" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p162-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesReconciliation/MTR:LossesUsedAgainstProfitsOfYear" mode="M163" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../MTR:TaxableProfits/MTR:UnusedLossesBroughtForward)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6576</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN60] must equal the amount in box [LUN51]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN60] should equal [LUN51]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M163" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M163" priority="-1"/>
  <axsl:template match="@*|node()" mode="M163" priority="-2">
    <axsl:apply-templates mode="M163" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p163-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesReconciliation/MTR:UnusedLossFromTheYear" mode="M164" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../MTR:AllowableLosses/MTR:UnusedLossesToCarryForward)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6577</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN61] must equal the amount in box [LUN58]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN61] should equal [LUN58]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M164" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M164" priority="-1"/>
  <axsl:template match="@*|node()" mode="M164" priority="-2">
    <axsl:apply-templates mode="M164" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p164-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesReconciliation/MTR:TotalLossToCarryForward" mode="M165" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:LossesBroughtForward) + sum(../MTR:UnusedLossFromTheYear)) - sum(../MTR:LossesUsedAgainstProfitsOfYear)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6253</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN62] must equal the sum of ( ( [LUN59] plus [LUN61] ) minus [LUN60] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN62] should equal ( ( [LUN59] plus [LUN61] ) minus [LUN60] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M165" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M165" priority="-1"/>
  <axsl:template match="@*|node()" mode="M165" priority="-2">
    <axsl:apply-templates mode="M165" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p166-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:NICs/MTR:PayClass2NICvoluntarily" mode="M166" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Class2NICamount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8347</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN63]. Please complete [LUNCL2].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUNCL2] should be present if [LUN63] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M166" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M166" priority="-1"/>
  <axsl:template match="@*|node()" mode="M166" priority="-2">
    <axsl:apply-templates mode="M166" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p167-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:NICs/MTR:Class2NICamount" mode="M167" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 182.85"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8348</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUNCL2] exceeds [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUNCL2] is valid only if this does not exceed [£182.85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M167" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M167" priority="-1"/>
  <axsl:template match="@*|node()" mode="M167" priority="-2">
    <axsl:apply-templates mode="M167" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p165-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:NICs" mode="M168" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexception or MTR:AdjustmentToClass4NICProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8346</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [LUN63-65] is present there must be an entry in at least one of [LUN63], [LUNCL2], [LUN64] or [LUN65]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LUN63-65] is present then at least one of the following should be present: [LUN63], [LUNCL2], [LUN64] or [LUN65]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M168" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M168" priority="-1"/>
  <axsl:template match="@*|node()" mode="M168" priority="-2">
    <axsl:apply-templates mode="M168" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p127-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L" mode="M169" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:UKIncome/MTR:UKInterest/MTR:BankEtcAndGiltUntaxedInterest or MTR:UKIncome/MTR:UKInterest/MTR:AccruedIncomeSchemeAggregateAmount or MTR:UKIncome/MTR:UKInterest/MTR:TaxedBankEtcInterest or MTR:UKIncome/MTR:UKInterest/MTR:TaxTakenOff) or MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6071</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN1] or [LUN2] or [LUN3] or [LUN4]. Please complete box [LUN5].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total UK interest and tax teken off should be present if [LUN1] or [LUN2] or [LUN3] or [LUN4]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AmountNonQualifyingForUKTaxCredit) or MTR:ForeignIncome/MTR:Dividends/MTR:NonUKDividendsAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6073</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN19]. Please complete box [LUN15].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>non UK dividends - amount should be present if [LUN19]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ForeignIncome/MTR:Interest/MTR:ForeignInterestEtcAmount or MTR:ForeignIncome/MTR:Interest/MTR:ForeignTaxDeducted or MTR:ForeignIncome/MTR:Interest/MTR:UKTaxDeducted or MTR:ForeignIncome/MTR:Dividends/MTR:NonUKDividendsAmount or MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted or MTR:ForeignIncome/MTR:Dividends/MTR:UKTaxDeducted) or MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6074</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN12] or [LUN13] or [LUN14] or [LUN15] or [LUN16] or [LUN17]. Please complete box [LUN18].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total non-UK income should be present if [LUN12] or [LUN13] or [LUN14] or [LUN15] or [LUN16] or [LUN17]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff or MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions or MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome or MTR:OtherReceipts/MTR:TotalOtherLloydsReceipts) or MTR:TotalLloydsIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6076</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN5] or [LUN11] or [LUN18] or [LUN26]. Please complete box [LUN27].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total Lloyd's income should be present if [LUN5] or [LUN11] or [LUN18] or [LUN26]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:LossesAndExpenses/MTR:AggregateSyndicateLosses) + sum(MTR:LossesAndExpenses/MTR:SpecialReserveFundNetTransfer) + sum(MTR:LossesAndExpenses/MTR:StopLossPremiumsPaid) + sum(MTR:LossesAndExpenses/MTR:PersonalQuotaShareAndExeatPremiums) + sum(MTR:LossesAndExpenses/MTR:EstateProtectionPlanPremiums) + sum(MTR:LossesAndExpenses/MTR:UnderwritingLoanInterest) + sum(MTR:LossesAndExpenses/MTR:LloydsMembersAssociationExpenses) + sum(MTR:LossesAndExpenses/MTR:MembersAgentProfitCommissionAndSalaries) + sum(MTR:LossesAndExpenses/MTR:BankGuaranteelettersOfCreditFees) + sum(MTR:LossesAndExpenses/MTR:AccountancyFees) + sum(MTR:LossesAndExpenses/MTR:OtherLloydsExpenses))) - (0) &gt;= 0.001)) or MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6077</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ) exceeds 0. Please complete box [LUN40].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total losses and expenses should be present if ( The sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:TotalLloydsIncome) - sum(MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) or MTR:ProfitAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6078</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [LUN27] minus [LUN40] ) exceeds 0. Please complete box [LUN41].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>profit amount should be present if ( [LUN27] minus [LUN40] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses) - sum(MTR:TotalLloydsIncome))) - (0) &gt;= 0.001)) or MTR:LossAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6079</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [LUN40] minus [LUN27] ) exceeds 0. Please complete box [LUN42].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>loss amount should be present if ( [LUN40] minus [LUN27] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ForeignIncome/MTR:Interest/MTR:ForeignTaxDeducted or MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted) or MTR:ForeignTax/MTR:ForeignTaxOnPersonalFundIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6080</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN13] or [LUN16]. Please complete box [LUN43].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>foreign tax on personal fund income should be present if [LUN13] or [LUN16]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:LossAmount) or MTR:AllowableLosses/MTR:LossAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6081</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN42]. Please complete box [LUN53].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>loss amount should be present if [LUN42]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AllowableLosses/MTR:LossAmount or MTR:AllowableLosses/MTR:ForeignTaxClaimedAsDeduction) or MTR:AllowableLosses/MTR:LossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6083</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN53] or [LUN54]. Please complete box [LUN55].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>loss for the year should be present if [LUN53] or [LUN54]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:TaxableProfits/MTR:UnusedLossesBroughtForward) or MTR:LossesReconciliation/MTR:LossesUsedAgainstProfitsOfYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6084</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN51]. Please complete box [LUN60].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>losses used against profits of year should be present if [LUN51]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:AllowableLosses/MTR:UnusedLossesToCarryForward) or MTR:LossesReconciliation/MTR:UnusedLossFromTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6085</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [LUN58]. Please complete box [LUN61].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>unused loss from the year should be present if [LUN58]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:UKIncome/MTR:UKDividends/MTR:StockDividendsAmountReceived or MTR:UKIncome/MTR:UKDividends/MTR:StockDividendsTaxCredit or MTR:UKIncome/MTR:UKDividends/MTR:NonQualifyingDistributionsAmountReceived or MTR:UKIncome/MTR:UKDividends/MTR:OtherDistributionsAmountReceived or MTR:UKIncome/MTR:UKDividends/MTR:OtherDistributionsTaxCredit) or MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6181</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [LUN6] or [LUN7] or [LUN8] or [LUN9] or [LUN10]. Please complete box [LUN11].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total UK dividends and distributions should be present if [LUN6] or [LUN7] or [LUN8] or [LUN9] or [LUN10]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(MTR:ProfitAmount) &gt; 0) or MTR:TaxableProfits/MTR:ProfitAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6184</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [LUN41] exceeds 0. Please complete box [LUN49].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>profit amount should be present if [LUN41] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:LossesReconciliation/MTR:LossesBroughtForward) + sum(MTR:LossesReconciliation/MTR:UnusedLossFromTheYear)) - sum(MTR:LossesReconciliation/MTR:LossesUsedAgainstProfitsOfYear))) - (0) &gt;= 0.001)) or MTR:LossesReconciliation/MTR:TotalLossToCarryForward"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6239</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [LUN59] plus [LUN61] ) minus [LUN60] ) exceeds 0. Please complete box [LUN62].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LUN62] should be present if ( ( [LUN59] plus [LUN61] ) minus [LUN60] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M169" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M169" priority="-1"/>
  <axsl:template match="@*|node()" mode="M169" priority="-2">
    <axsl:apply-templates mode="M169" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p169-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:PartnershipReferenceNumber" mode="M170" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) &gt; 9) and (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) - 9))                 or                 (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6254</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry must be valid against the UTR algorithm. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must be valid against the UTR algorithm</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="('1111111111' != (.))                  and               ('2222222222' != (.))                  and               ('3333333333' != (.))                  and               ('4444444444' != (.))                  and               ('5555555555' != (.))                  and               ('6666666666' != (.))                  and               ('7777777777' != (.))                  and               ('8888888888' != (.))                  and               ('9999999999' != (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8210</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M170" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M170" priority="-1"/>
  <axsl:template match="@*|node()" mode="M170" priority="-2">
    <axsl:apply-templates mode="M170" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p170-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:DateJoinedPartnership" mode="M171" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6731</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date entered must be within the return period.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS3] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M171" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M171" priority="-1"/>
  <axsl:template match="@*|node()" mode="M171" priority="-2">
    <axsl:apply-templates mode="M171" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p171-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:DateLeftPartnership" mode="M172" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6731</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date entered must be within the return period.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS4] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:DateJoinedPartnership) or translate((.),'-','') &gt;= translate(../MTR:DateJoinedPartnership,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6106</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date in [FPS4] must be the same as or later than the date in [FPS3], if both [FPS3] and [FPS4] completed. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If both [FPS3] and [FPS4] present then [FPS4] must be &gt;= [FPS3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M172" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M172" priority="-1"/>
  <axsl:template match="@*|node()" mode="M172" priority="-2">
    <axsl:apply-templates mode="M172" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p173-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:DateBasisPeriodBegan" mode="M173" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="translate((.),'-','') &lt;= translate(../MTR:DateBasisPeriodEnded,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6733</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FPS6]. The entry in box [FPS7] must be the same as or later than [FPS6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FPS6] present [FPS7] must be the same as or later than [FPS6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M173" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M173" priority="-1"/>
  <axsl:template match="@*|node()" mode="M173" priority="-2">
    <axsl:apply-templates mode="M173" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p174-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:LossesBroughtForward" mode="M174" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:AdjustedProfitForYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6737</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS17] exceeds the amount in box [FPS16]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS17] should not exceed [FPS16]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M174" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M174" priority="-1"/>
  <axsl:template match="@*|node()" mode="M174" priority="-2">
    <axsl:apply-templates mode="M174" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p175-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:TaxableProfitsAfterLosses" mode="M175" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForYear) - sum(../MTR:LossesBroughtForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6738</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS18] must equal ( [FPS16] minus [FPS17] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS18] should equal ( [FPS16] minus [FPS17] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M175" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M175" priority="-1"/>
  <axsl:template match="@*|node()" mode="M175" priority="-2">
    <axsl:apply-templates mode="M175" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p176-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits" mode="M176" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:TaxableProfitsAfterLosses) + sum(../MTR:OtherBusinessIncome)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6739</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS20] must equal ( [FPS18] plus [FPS19] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS20] should equal ( [FPS18] plus [FPS19] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M176" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M176" priority="-1"/>
  <axsl:template match="@*|node()" mode="M176" priority="-2">
    <axsl:apply-templates mode="M176" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p172-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits" mode="M177" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed)))) - (0) &lt; 0.001)                 or               (MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed))) + sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment)) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8219</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS16] must equal ([FPS8] + [FPS9] + [FPS10] + [FPS11] - ([FPS12] + [FPS13])) if the sum of ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is positive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is positive, then [FPS16] is mandatory and equals ([FPS8] + [FPS9] - ([FPS12] + [FPS13]) + [FPS10] + [FPS11])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed)))) - (0) &gt;= 0.001)                 or               ( (((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment))) - (0) &lt; 0.001) and sum(MTR:AdjustedProfitForYear) = 0)                 or               ( (((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment))) - (0) &gt;= 0.001) and MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment))) - (MTR:AdjustedProfitForYear)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8220</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is negative or zero. If ([FPS10] + [FPS11]) is greater than zero, the amount in box [FPS16] must equal ([FPS10] + [FPS11] or [FPS16] must be zero or absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is negative or zero, then if ([FPS10] + [FPS11]) is greater than zero, then [FPS16]  is mandatory and equals ([FPS10] + [FPS11]); else [FPS16] must be zero or absent.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed)))) - (0) &lt;= -0.001))             or           (math:abs((math:abs((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed))))) - (sum(../MTR:ShareOfLosses/MTR:AdjustedLossForYear))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8221</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is negative. Please complete box [FPS21] with the positive equivalent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is negative, then [FPS21] is mandatory and  = positive equivalent of ([FPS8] + [FPS9] - ([FPS12] + [FPS13]))</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M177" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M177" priority="-1"/>
  <axsl:template match="@*|node()" mode="M177" priority="-2">
    <axsl:apply-templates mode="M177" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p177-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:AdjustedLossForYear" mode="M178" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../../MTR:ShareOfProfits/MTR:ShareOfPartnershipProfitOrLoss) + sum(../../MTR:ShareOfProfits/MTR:AdjustmentForBasisPeriod) - (sum(../../MTR:ShareOfProfits/MTR:ForeignTaxClaimedAsDeduction) + sum(../../MTR:ShareOfProfits/MTR:OverlapReliefUsed)))) - (0) &lt;= -0.001)             or           (math:abs((0) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8222</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is greater than or equal to zero. The entry in box [FPS21] must equal 0 or be absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS8] + [FPS9] - ([FPS12] + [FPS13])) is greater than or equal to zero, then [FPS21] = 0 or is absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M178" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M178" priority="-1"/>
  <axsl:template match="@*|node()" mode="M178" priority="-2">
    <axsl:apply-templates mode="M178" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p178-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:LossSetOffAgainstOtherIncome" mode="M179" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:AdjustedLossForYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6108</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS22] exceeds the amount in box [FPS21]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS22] should not exceed [FPS21]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../MTR:PartnershipDetails/MTR:CashBasis)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8349</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [FPS22] should not be present as there is an entry in [FPS5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS22] should not be present if [FPS5] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M179" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M179" priority="-1"/>
  <axsl:template match="@*|node()" mode="M179" priority="-2">
    <axsl:apply-templates mode="M179" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p179-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:LossToBeCarriedBack" mode="M180" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:AdjustedLossForYear) - sum(../MTR:LossSetOffAgainstOtherIncome))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6741</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS23] exceeds ( [FPS21] minus [FPS22] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS23] should not exceed ( [FPS21] minus [FPS22] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M180" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M180" priority="-1"/>
  <axsl:template match="@*|node()" mode="M180" priority="-2">
    <axsl:apply-templates mode="M180" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p181-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:NICs/MTR:PayClass2NICvoluntarily" mode="M181" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Class2NICamount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8352</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS25]. Please complete [FPSCL2]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPSCL2] should be present if [FPS25] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M181" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M181" priority="-1"/>
  <axsl:template match="@*|node()" mode="M181" priority="-2">
    <axsl:apply-templates mode="M181" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p182-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:NICs/MTR:Class2NICamount" mode="M182" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 182.85"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8353</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPSCL2] exceeds [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPSCL2] is valid only if this does not exceed [£182.85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M182" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M182" priority="-1"/>
  <axsl:template match="@*|node()" mode="M182" priority="-2">
    <axsl:apply-templates mode="M182" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p180-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:NICs" mode="M183" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexception or MTR:AdjustmentToClass4NICProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8351</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [FPS25-27] is present there must be an entry in at least one of [FPS25], [FPSCL2], [FPS26] or [FPS27]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FPS25-27] is present then at least one of the following should be present: [FPS25], [FPSCL2], [FPS26] or [FPS27]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M183" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M183" priority="-1"/>
  <axsl:template match="@*|node()" mode="M183" priority="-2">
    <axsl:apply-templates mode="M183" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p183-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:AdjustedUKSavingsIncome" mode="M184" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:UKUntaxedSavingsIncomeShare) + sum(../MTR:BasisPeriodAdjustment)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6743</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS30] must equal ( [FPS28] plus [FPS29] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS30] should equal ( [FPS28] plus [FPS29] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M184" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M184" priority="-1"/>
  <axsl:template match="@*|node()" mode="M184" priority="-2">
    <axsl:apply-templates mode="M184" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p184-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome" mode="M185" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:ForeignUntaxedSavingsIncomeShare) + sum(../MTR:BasisPeriodAdjustment)) - sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6744</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS34] must equal ( ( [FPS31] plus [FPS32] ) minus [FPS33] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS34] should equal ( ( [FPS31] plus [FPS32] ) minus [FPS33] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M185" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M185" priority="-1"/>
  <axsl:template match="@*|node()" mode="M185" priority="-2">
    <axsl:apply-templates mode="M185" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p185-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:TotalUntaxedSavingsIncome" mode="M186" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AdjustedUKSavingsIncome) + sum(../MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6745</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS35] must equal ( [FPS30] plus [FPS34] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS35] should equal ( [FPS30] plus [FPS34] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M186" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M186" priority="-1"/>
  <axsl:template match="@*|node()" mode="M186" priority="-2">
    <axsl:apply-templates mode="M186" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p186-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:LossBroughtForward" mode="M187" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment)) - (0) &lt; 0.001) or ((.) - (sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6746</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS38] cannot exceed the sum of [FPS36]+[FPS37] where the sum is positive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS38] cannot exceed the sum of [FPS36]+[FPS37] where the sum is positive</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M187" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M187" priority="-1"/>
  <axsl:template match="@*|node()" mode="M187" priority="-2">
    <axsl:apply-templates mode="M187" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p187-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:LossForYearSetOffAgainstOtherIncome" mode="M188" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment)) - (0) &gt; -0.001) or ((0 - (.)) - (sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment)) &gt; -0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6747</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS39] cannot exceed the positive equivalent of the sum of [FPS36] + [FPS37]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>where the sum of [FPS36] + [FPS37] is negative, [FPS39] cannot exceed the sum's positive equivalent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M188" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M188" priority="-1"/>
  <axsl:template match="@*|node()" mode="M188" priority="-2">
    <axsl:apply-templates mode="M188" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p188-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses" mode="M189" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment) - sum(../MTR:LossBroughtForward))) - (0) &lt;= -0.001)             or           (math:abs(((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment) - sum(../MTR:LossBroughtForward))) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6204</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [FPS41] must equal the sum of ([FPS36] + [FPS37] - [FPS38]) if positive or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>if ([FPS36] + [FPS37] - [FPS38]) is positive or zero, then [FPS41] = [FPS36] + [FPS37] - [FPS38]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((0) - ((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:BasisPeriodAdjustment) - sum(../MTR:LossBroughtForward))) &lt; 0.001)             or           (math:abs((0) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6205</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FPS36] + [FPS37] - [FPS38]) is negative. The entry in box [FPS41] must equal 0. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>if ([FPS36] + [FPS37] - [FPS38]) is negative, [FPS41] = 0 </axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M189" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M189" priority="-1"/>
  <axsl:template match="@*|node()" mode="M189" priority="-2">
    <axsl:apply-templates mode="M189" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p189-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:TaxableFHLProfit" mode="M190" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:ShareOfFHLProfit or ../MTR:AdjustmentsToFHLProfit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8258</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [FPS44] must not be present as there is no entry in neither box [FPS42] nor box [FPS43]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS44] should not be present if neither [FPS42] nor [FPS43] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((sum(../MTR:ShareOfFHLProfit) + sum(../MTR:AdjustmentsToFHLProfit)) &gt; 0) or (math:abs(((.)) - ((sum(../MTR:ShareOfFHLProfit) + sum(../MTR:AdjustmentsToFHLProfit)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8259</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS44] must equal ([FPS42] + [FPS43]) if greater than zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS42] + [FPS43]) is greater than zero, [FPS44] must equal ([FPS42] + [FPS43])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../MTR:ShareOfFHLProfit) + sum(../MTR:AdjustmentsToFHLProfit)) &gt; 0) or ((.) = 0.00)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8260</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS44] must equal zero if ([FPS42] + [FPS43]) is less than or equal to zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS42] + [FPS43]) is less than or equal to zero, [FPS44] must equal zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M190" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M190" priority="-1"/>
  <axsl:template match="@*|node()" mode="M190" priority="-2">
    <axsl:apply-templates mode="M190" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p191-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome/MTR:LossBroughtForward" mode="M191" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:OtherUntaxedUKIncomeShare) + sum(../MTR:BasisPeriodAdjustment))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6753</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS47] exceeds ( [FPS45] plus [FPS46] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS47] should not exceed ( [FPS45] plus [FPS46] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M191" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M191" priority="-1"/>
  <axsl:template match="@*|node()" mode="M191" priority="-2">
    <axsl:apply-templates mode="M191" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p192-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome/MTR:TaxableProfit" mode="M192" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (((sum(../MTR:OtherUntaxedUKIncomeShare) + sum(../MTR:BasisPeriodAdjustment)) - sum(../MTR:LossBroughtForward))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6259</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS48] exceeds the sum of ( ( [FPS45] plus [FPS46] ) minus [FPS47] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS48] should not exceed ( ( [FPS45] plus [FPS46] ) minus [FPS47] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M192" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M192" priority="-1"/>
  <axsl:template match="@*|node()" mode="M192" priority="-2">
    <axsl:apply-templates mode="M192" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p190-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome" mode="M193" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:OtherUntaxedUKIncomeShare or MTR:BasisPeriodAdjustment or MTR:LossBroughtForward)               or             not(((((sum(MTR:OtherUntaxedUKIncomeShare) + sum(MTR:BasisPeriodAdjustment)) - sum(MTR:LossBroughtForward))) - (0) &gt; -0.001))               or             MTR:TaxableProfit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6206</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([FPS45] + [FPS46] - [FPS47] ) is equal to or greater than zero. Please complete box [FPS48].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If any of [FPS45], [FPS46] or [FPS47] are present, then [FPS48] is mandatory if ([FPS45] + [FPS46] - [FPS47] ) &gt;= 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M193" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M193" priority="-1"/>
  <axsl:template match="@*|node()" mode="M193" priority="-2">
    <axsl:apply-templates mode="M193" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p193-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax" mode="M194" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:OffshoreFundsIncomeShare) + sum(../MTR:BasisPeriodAdjustment)) - sum(../MTR:ForeignTaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6755</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS55] must equal ( ( [FPS52] plus [FPS53] ) minus [FPS54] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS55] should equal ( ( [FPS52] plus [FPS53] ) minus [FPS54] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M194" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M194" priority="-1"/>
  <axsl:template match="@*|node()" mode="M194" priority="-2">
    <axsl:apply-templates mode="M194" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p194-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:OtherUntaxedForeignIncomeShare" mode="M195" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableProfit or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6260</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS56]. Please complete box [FPS60].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS60] mandatory if [FPS56]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M195" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M195" priority="-1"/>
  <axsl:template match="@*|node()" mode="M195" priority="-2">
    <axsl:apply-templates mode="M195" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p195-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:BasisPeriodAdjustment" mode="M196" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableProfit or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6262</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS57]. Please complete box [FPS60].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS60] mandatory if [FPS57]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M196" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M196" priority="-1"/>
  <axsl:template match="@*|node()" mode="M196" priority="-2">
    <axsl:apply-templates mode="M196" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p196-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:LossBroughtForward" mode="M197" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableProfit or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6263</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS58]. Please complete box [FPS60].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS60] mandatory if [FPS58]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:BasisPeriodAdjustment))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6756</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS58] exceeds ( [FPS56] plus [FPS57] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS58] should not exceed ( [FPS56] plus [FPS57] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M197" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M197" priority="-1"/>
  <axsl:template match="@*|node()" mode="M197" priority="-2">
    <axsl:apply-templates mode="M197" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p197-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TotalForeignTaxTakenOff" mode="M198" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableProfit or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6264</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS59]. Please complete box [FPS60].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS60] mandatory if [FPS59]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M198" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M198" priority="-1"/>
  <axsl:template match="@*|node()" mode="M198" priority="-2">
    <axsl:apply-templates mode="M198" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p198-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfit" mode="M199" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:BasisPeriodAdjustment)) - (sum(../MTR:LossBroughtForward) + sum(../MTR:TotalForeignTaxTakenOff))) - (0) &gt; -0.001)) or (math:abs((.) - ((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:BasisPeriodAdjustment)) - (sum(../MTR:LossBroughtForward) + sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6266</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS60] must equal the sum of ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) if greater than or equal to zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is greater than or equal to zero then [FPS60] equals that sum.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:BasisPeriodAdjustment)) - (sum(../MTR:LossBroughtForward) + sum(../MTR:TotalForeignTaxTakenOff))) - (0) &lt;= -0.001)) or . = 0.00"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6267</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS60] must equal zero if the sum of ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is negative. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is negative then [FPS60] equals zero.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M199" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M199" priority="-1"/>
  <axsl:template match="@*|node()" mode="M199" priority="-2">
    <axsl:apply-templates mode="M199" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p199-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncome" mode="M200" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses) + sum(../../MTR:TaxableFHLProfit) + sum(../../MTR:OtherUntaxedUKIncome/MTR:TaxableProfit) + sum(../../MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax) + sum(../../MTR:OtherUntaxedForeignIncome/MTR:TaxableProfit)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8261</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS64] must equal  the sum of ( [FPS41], [FPS44], [FPS48], [FPS55], and [FPS60] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS64] is valid if and only if this equals ( The sum of [FPS41], [FPS44], [FPS48], [FPS55], and [FPS60] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M200" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M200" priority="-1"/>
  <axsl:template match="@*|node()" mode="M200" priority="-2">
    <axsl:apply-templates mode="M200" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p200-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncomeShare" mode="M201" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:TotalUntaxedIncome) - sum(../MTR:OverlapReliefUsed)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6759</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS67] must equal ( [FPS64] minus [FPS65] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS67] should equal ( [FPS64] minus [FPS65] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M201" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M201" priority="-1"/>
  <axsl:template match="@*|node()" mode="M201" priority="-2">
    <axsl:apply-templates mode="M201" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p201-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt10Percent/MTR:TaxedIncomeTaxable" mode="M202" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:ShareOfTaxedIncome) - sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6760</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS70] must equal ( [FPS68] minus [FPS69] ). Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS70] should equal ( [FPS68] minus [FPS69] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M202" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M202" priority="-1"/>
  <axsl:template match="@*|node()" mode="M202" priority="-2">
    <axsl:apply-templates mode="M202" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p202-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:TaxedIncomeTaxableAt20Percent" mode="M203" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:ShareOfTaxedIncome) - sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6761</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS73] must equal ( [FPS71] minus [FPS72] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS73] should equal ( [FPS71] minus [FPS72] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M203" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M203" priority="-1"/>
  <axsl:template match="@*|node()" mode="M203" priority="-2">
    <axsl:apply-templates mode="M203" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p203-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfTotalTaxedAndUntaxedIncome" mode="M204" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../../MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits) + sum(../../MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncomeShare) + sum(../MTR:ShareOfOtherTaxedIncome/MTR:ShareOfTaxedIncome)) - sum(../MTR:ShareOfOtherTaxedIncome/MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6762</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS76] must equal ( ( the sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
share of total taxed and untaxed income is valid if and only if this equals ( ( The sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M204" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M204" priority="-1"/>
  <axsl:template match="@*|node()" mode="M204" priority="-2">
    <axsl:apply-templates mode="M204" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p204-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfTotalTaxTakenOff" mode="M205" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:ShareOfIncomeTaxTakenOffPartnershipIncome) + sum(../MTR:ShareOfTaxTakenOffByContractors) + sum(../MTR:ShareOfTaxTakenOffTradingIncome) + sum(../MTR:ShareOfTaxCredits)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6763</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FPS81] must equal ( the sum of [FPS77], [FPS78], [FPS79], and [FPS80] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS81] should equal ( The sum of [FPS77], [FPS78], [FPS79], and [FPS80] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M205" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M205" priority="-1"/>
  <axsl:template match="@*|node()" mode="M205" priority="-2">
    <axsl:apply-templates mode="M205" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p168-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F" mode="M206" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfProfits/MTR:DateBasisPeriodEnded) or MTR:ShareOfProfits/MTR:DateBasisPeriodBegan"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6088</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FPS7]. Please complete box [FPS6].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>date basis period began should be present if [FPS7]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfProfits/MTR:DateBasisPeriodBegan) or MTR:ShareOfProfits/MTR:DateBasisPeriodEnded"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6089</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FPS6]. Please complete box [FPS7].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>date basis period ended should be present if [FPS6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfProfits/MTR:AdjustedProfitForYear or MTR:ShareOfProfits/MTR:LossesBroughtForward) or MTR:ShareOfProfits/MTR:TaxableProfitsAfterLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6090</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS16] or [FPS17]. Please complete box [FPS18].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxable profits after losses should be present if [FPS16] or [FPS17]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfProfits/MTR:TaxableProfitsAfterLosses or MTR:ShareOfProfits/MTR:OtherBusinessIncome) or MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6091</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS18] or [FPS19]. Please complete box [FPS20].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total taxable business profits should be present if [FPS18] or [FPS19]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:UKUntaxedSavingsIncomeShare or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:BasisPeriodAdjustment) or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:AdjustedUKSavingsIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6092</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS28] or [FPS29]. Please complete box [FPS30].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>adjusted UK savings income should be present if [FPS28] or [FPS29]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:ForeignUntaxedSavingsIncomeShare or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:BasisPeriodAdjustment or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:TotalForeignTaxTakenOff) or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6093</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS31] or [FPS32] or [FPS33]. Please complete box [FPS34].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>adjusted foreign savings income should be present if [FPS31] or [FPS32] or [FPS33]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:AdjustedUKSavingsIncome or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome) or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:TotalUntaxedSavingsIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6094</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS30] or [FPS34]. Please complete box [FPS35].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total untaxed savings income  should be present if [FPS30] or [FPS34]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:OffshoreFundsIncomeShare) + sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:BasisPeriodAdjustment)) - sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:ForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6097</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [FPS52] plus [FPS53] ) minus [FPS54] ) exceeds 0. Please complete box [FPS55]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxable income after adjustment and foreign tax should be present if ( ( [FPS52] plus [FPS53] ) minus [FPS54] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses) + sum(MTR:ShareOfUntaxedIncome/MTR:TaxableFHLProfit) + sum(MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome/MTR:TaxableProfit) + sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax) + sum(MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfit))) - (0) &gt;= 0.001)) or MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8255</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [FPS41], [FPS44], [FPS48], [FPS55], and [FPS60] ) exceeds 0. Please complete box [FPS64].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS64] should be present if ( The sum of [FPS41], [FPS44], [FPS48], [FPS55], and [FPS60] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncome) - sum(MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:OverlapReliefUsed))) - (0) &gt;= 0.001)) or MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncomeShare"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6100</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [FPS64] minus [FPS65] ) exceeds 0. Please complete box [FPS67].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total untaxed income share should be present if ( [FPS64] minus [FPS65] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt10Percent/MTR:ShareOfTaxedIncome) - sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt10Percent/MTR:TotalForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt10Percent/MTR:TaxedIncomeTaxable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6101</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [FPS68] minus [FPS69] ) exceeds 0. Please complete box [FPS70].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxed income taxable at 10% should be present if ( [FPS68] minus [FPS69] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:ShareOfTaxedIncome) - sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:TotalForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:TaxedIncomeTaxableAt20Percent"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6103</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [FPS71] minus [FPS72] ) exceeds 0. Please complete box [FPS73].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxed income taxable at 20% should be present if ( [FPS71] minus [FPS72] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits) + sum(MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncome/MTR:TotalUntaxedIncomeShare) + sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfOtherTaxedIncome/MTR:ShareOfTaxedIncome)) - sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfOtherTaxedIncome/MTR:TotalForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipIncome/MTR:ShareOfTotalTaxedAndUntaxedIncome"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6104</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ) exceeds 0. Please complete box [FPS76].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>
share of total taxed and untaxed income should be present if ( ( The sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfIncomeTaxTakenOffPartnershipIncome or MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfTaxTakenOffByContractors or MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfTaxTakenOffTradingIncome or MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfTaxCredits) or MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfTotalTaxTakenOff"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6105</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS77] or [FPS78] or [FPS79] or [FPS80]. Please complete box [FPS81].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>share of total tax taken off should be present if [FPS77] or [FPS78] or [FPS79] or [FPS80]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:UKPropertyProfitLossShare or MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:BasisPeriodAdjustment or MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:LossBroughtForward) or MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6201</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS36] or [FPS37] or [FPS38]. Please complete box [FPS41].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxable profits after adjustment and losses should be present if [FPS36] or [FPS37] or [FPS38]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfUntaxedIncome/MTR:ShareOfFHLProfit) or MTR:ShareOfUntaxedIncome/MTR:TaxableFHLProfit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8256</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS42]. Please complete box [FPS44]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS44] should be present if [FPS42] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfUntaxedIncome/MTR:AdjustmentsToFHLProfit) or MTR:ShareOfUntaxedIncome/MTR:TaxableFHLProfit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8257</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FPS43]. Please complete box [FPS44].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FPS44] should be present if [FPS43] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M206" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M206" priority="-1"/>
  <axsl:template match="@*|node()" mode="M206" priority="-2">
    <axsl:apply-templates mode="M206" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p206-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:PartnershipReferenceNumber" mode="M207" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) &gt; 9) and (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) - 9))                 or                 (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6269</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry must be valid against the UTR algorithm. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must be valid against the UTR algorithm</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="('1111111111' != (.))                  and               ('2222222222' != (.))                  and               ('3333333333' != (.))                  and               ('4444444444' != (.))                  and               ('5555555555' != (.))                  and               ('6666666666' != (.))                  and               ('7777777777' != (.))                  and               ('8888888888' != (.))                  and               ('9999999999' != (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8210</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M207" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M207" priority="-1"/>
  <axsl:template match="@*|node()" mode="M207" priority="-2">
    <axsl:apply-templates mode="M207" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p207-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:DateJoinedPartnership" mode="M208" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6731</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date entered must be within the return period.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS3] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M208" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M208" priority="-1"/>
  <axsl:template match="@*|node()" mode="M208" priority="-2">
    <axsl:apply-templates mode="M208" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p208-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:DateLeftPartnership" mode="M209" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6731</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date entered must be within the return period.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS4] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:DateJoinedPartnership) or translate((.),'-','') &gt;= translate(../MTR:DateJoinedPartnership,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6112</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The date in [SPS4] must be same as or later than the date in [SPS3], if both [SPS3] and [SPS4] completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If both [SPS3] and [SPS4] present then [SPS4] must be same as or later than [SPS3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M209" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M209" priority="-1"/>
  <axsl:template match="@*|node()" mode="M209" priority="-2">
    <axsl:apply-templates mode="M209" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p210-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:DateBasisPeriodBegan" mode="M210" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="translate(../MTR:DateBasisPeriodEnded,'-','') &gt;= translate((.),'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6766</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [SPS6]. The entry in box [SPS7] must be the same as or later than [SPS6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SPS6] present [SPS7] must be the same as or later than [SPS6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M210" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M210" priority="-1"/>
  <axsl:template match="@*|node()" mode="M210" priority="-2">
    <axsl:apply-templates mode="M210" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p211-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:DateBasisPeriodEnded" mode="M211" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DateBasisPeriodBegan"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6113</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [SPS7] completed. Please complete box [SPS6].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SPS7] present then [SPS6] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M211" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M211" priority="-1"/>
  <axsl:template match="@*|node()" mode="M211" priority="-2">
    <axsl:apply-templates mode="M211" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p212-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:ShareOfPartnershipProfitOrLoss" mode="M212" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DateBasisPeriodBegan"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6769</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [SPS8]. Please complete box [SPS6].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If share of partnership profit or loss is present the following should be true: [SPS6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M212" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M212" priority="-1"/>
  <axsl:template match="@*|node()" mode="M212" priority="-2">
    <axsl:apply-templates mode="M212" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p213-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:LossesBroughtForward" mode="M213" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:AdjustedProfitForYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6781</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPS17] exceeds the amount in box [SPS16]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS17] should not exceed [SPS16]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M213" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M213" priority="-1"/>
  <axsl:template match="@*|node()" mode="M213" priority="-2">
    <axsl:apply-templates mode="M213" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p214-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxableProfitsAfterLosses" mode="M214" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForYear) - sum(../MTR:LossesBroughtForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6783</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPS18] must equal ( [SPS16] minus [SPS17] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS18] should equal ( [SPS16] minus [SPS17] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M214" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M214" priority="-1"/>
  <axsl:template match="@*|node()" mode="M214" priority="-2">
    <axsl:apply-templates mode="M214" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p215-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits" mode="M215" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:TaxableProfitsAfterLosses) + sum(../MTR:OtherBusinessIncome)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6784</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPS20] must equal ( [SPS18] plus [SPS19] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS20] should equal ( [SPS18] plus [SPS19] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M215" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M215" priority="-1"/>
  <axsl:template match="@*|node()" mode="M215" priority="-2">
    <axsl:apply-templates mode="M215" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p209-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits" mode="M216" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed)))) - (0) &lt; 0.001)                 or               (MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed))) + sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment)) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8223</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPS16] must equal ([SPS8] + [SPS9] + [SPS10] + [SPS11] - ([SPS12] + [SPS13])) if the sum of ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is positive. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is positive, then [SPS16] is mandatory and = ([SPS8] + [SPS9] + [SPS10] + [SPS11] - ([SPS12] + [SPS13]))</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed)))) - (0) &gt;= 0.001)               or             ( (((sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment))) - (0) &gt;= 0.001) and (MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment))) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001)) )               or             ( (((sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment))) - (0) &lt; 0.001) and ((math:abs((0) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001)) )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8224</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is negative or zero. If ([SPS10] + [SPS11]) is greater than zero, the amount in box [SPS16] must equal ([SPS10] + [SPS11]) or [SPS16] must be zero or absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is negative or zero, then if ([SPS10] + [SPS11]) is greater than zero, then [SPS16] is mandatory and equals ([SPS10] + [SPS11]); else [SPS16] must be zero or absent.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed)))) - (0) &lt;= -0.001))             or           (math:abs((math:abs((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:AdjustmentForBasisPeriod) - (sum(MTR:ForeignTaxClaimedAsDeduction) + sum(MTR:OverlapReliefUsed))))) - (sum(../MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:AdjustedLossForYear))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8225</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is negative. Please complete box [SPS21] with the positive equivalent.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([SPS8] + [SPS9]  - ([SPS12] + [SPS13])) is negative, then [SPS21] is mandatory and  = positive equivalent of ([SPS8] + [SPS9] - ([SPS12] + [SPS13]))</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M216" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M216" priority="-1"/>
  <axsl:template match="@*|node()" mode="M216" priority="-2">
    <axsl:apply-templates mode="M216" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p216-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:AdjustedLossForYear" mode="M217" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:ShareOfPartnershipProfitOrLoss) + sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AdjustmentForBasisPeriod) - (sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:ForeignTaxClaimedAsDeduction) + sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:OverlapReliefUsed)))) - (0) &lt;= -0.001)             or           (math:abs((0) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8226</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is greater than or equal to zero. The entry in box [SPS21] must equal 0 or be absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([SPS8] + [SPS9] - ([SPS12] + [SPS13])) is greater than or equal to zero, then [SPS21] = 0 or is absent.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M217" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M217" priority="-1"/>
  <axsl:template match="@*|node()" mode="M217" priority="-2">
    <axsl:apply-templates mode="M217" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p217-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:LossSetOffAgainstOtherIncome" mode="M218" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:AdjustedLossForYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6116</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPS22] exceeds the amount in box [SPS21]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS22] should not exceed [SPS21]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../MTR:PartnershipDetails/MTR:CashBasis)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8354</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [SPS22] should not be present as there is an entry in [SPS5]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS22] should not be present if [SPS5] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M218" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M218" priority="-1"/>
  <axsl:template match="@*|node()" mode="M218" priority="-2">
    <axsl:apply-templates mode="M218" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p218-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:LossToBeCarriedBack" mode="M219" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:AdjustedLossForYear) - sum(../MTR:LossSetOffAgainstOtherIncome))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6785</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPS23] exceeds ( [SPS21] minus [SPS22] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPS23] should not exceed ( [SPS21] minus [SPS22] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M219" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M219" priority="-1"/>
  <axsl:template match="@*|node()" mode="M219" priority="-2">
    <axsl:apply-templates mode="M219" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p220-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:NICs/MTR:PayClass2NICvoluntarily" mode="M220" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Class2NICamount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8356</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [SPS25]. Please complete [SPSCL2]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPSCL2] should be present if [SPS25] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M220" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M220" priority="-1"/>
  <axsl:template match="@*|node()" mode="M220" priority="-2">
    <axsl:apply-templates mode="M220" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p221-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:NICs/MTR:Class2NICamount" mode="M221" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 182.85"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8357</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [SPSCL2] exceeds [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SPSCL2] is valid only if this does not exceed [£182.85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M221" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M221" priority="-1"/>
  <axsl:template match="@*|node()" mode="M221" priority="-2">
    <axsl:apply-templates mode="M221" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p219-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:NICs" mode="M222" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexception or MTR:AdjustmentToClass4NICProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8355</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If [SPS25-27] is present there must be an entry in at least one of [SPS25], [SPSCL2], [SPS26] or [SPS27]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SPS25-27] is present then at least one of the following should be present: [SPS25], [SPSCL2], [SPS26] or [SPS27]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M222" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M222" priority="-1"/>
  <axsl:template match="@*|node()" mode="M222" priority="-2">
    <axsl:apply-templates mode="M222" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p205-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S" mode="M223" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AdjustedProfitForYear) - sum(MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:LossesBroughtForward))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxableProfitsAfterLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6109</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [SPS16] minus [SPS17] ) exceeds 0. Please complete box [SPS18].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxable profits after losses should be present if ( [SPS16] minus [SPS17] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxableProfitsAfterLosses or MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:OtherBusinessIncome) or MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6110</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [SPS18] or [SPS19]. Please complete box [SPS20].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total taxable business profits should be present if [SPS18] or [SPS19]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M223" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M223" priority="-1"/>
  <axsl:template match="@*|node()" mode="M223" priority="-2">
    <axsl:apply-templates mode="M223" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p224-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:FurnishedHolidayLettings/MTR:PrivateUseAdjustment" mode="M224" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../MTR:FurnishedHolidayLettingsExpenses) + sum(../MTR:FurnishedHolidayLettingsInterestEtcCosts) + sum(../MTR:FurnishedHolidayLettingsManagementEtcFees) + sum(../MTR:FurnishedHolidayLettingsOtherExpenses))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6140</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO10] exceeds ( the sum of [PRO6], [PRO7], [PRO8], and [PRO9] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO10] should not exceed ( The sum of [PRO6], [PRO7], [PRO8], and [PRO9] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M224" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M224" priority="-1"/>
  <axsl:template match="@*|node()" mode="M224" priority="-2">
    <axsl:apply-templates mode="M224" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p225-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:FurnishedHolidayLettings/MTR:AdjustedProfitForTheYear" mode="M225" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../MTR:FurnishedHolidayLettingsIncome) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges) - (sum(../MTR:FurnishedHolidayLettingsExpenses) + sum(../MTR:FurnishedHolidayLettingsInterestEtcCosts) + sum(../MTR:FurnishedHolidayLettingsManagementEtcFees) + sum(../MTR:FurnishedHolidayLettingsOtherExpenses) + sum(../MTR:CapitalAllowances) )) - (0) &lt;= -0.001) or (math:abs((.) - (sum(../MTR:FurnishedHolidayLettingsIncome) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges) - (sum(../MTR:FurnishedHolidayLettingsExpenses) + sum(../MTR:FurnishedHolidayLettingsInterestEtcCosts) + sum(../MTR:FurnishedHolidayLettingsManagementEtcFees) + sum(../MTR:FurnishedHolidayLettingsOtherExpenses) + sum(../MTR:CapitalAllowances) ))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8267</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO13] must equal the sum of [PRO5] + [PRO10] + [PRO11] minus sum of ([PRO6] + [PRO7] + [PRO8] + [PRO9] + [PRO12]) if positive or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If the sum of [PRO5] + [PRO10] + [PRO11] minus sum of ([PRO6] + [PRO7] + [PRO8] + [PRO9] + [PRO12]) is positive or zero then [PRO13] must equal that sum </axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M225" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M225" priority="-1"/>
  <axsl:template match="@*|node()" mode="M225" priority="-2">
    <axsl:apply-templates mode="M225" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p226-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:FurnishedHolidayLettings/MTR:TaxableProfitForYear" mode="M226" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(../MTR:AdjustedProfitForTheYear) - sum(../MTR:LossesBroughtForward))) - (0) &gt; -0.001)) or (math:abs(((.)) - ((sum(../MTR:AdjustedProfitForTheYear) - sum(../MTR:LossesBroughtForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8266</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO15] must equal ([PRO13] minus [PRO14]) if greater than or equal to zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([PRO13] minus [PRO14]) is greater than or equal to zero then [PRO15] must equal that sum if it is present..</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M226" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M226" priority="-1"/>
  <axsl:template match="@*|node()" mode="M226" priority="-2">
    <axsl:apply-templates mode="M226" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p227-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:FurnishedHolidayLettings/MTR:LossForYear" mode="M227" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../MTR:TaxableProfitForYear) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8268</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [PRO16], box [PRO15] must be absent or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [PRO16] present then [PRO15] must be absent or zero.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(../MTR:FurnishedHolidayLettingsExpenses) + sum(../MTR:FurnishedHolidayLettingsInterestEtcCosts) + sum(../MTR:FurnishedHolidayLettingsManagementEtcFees) + sum(../MTR:FurnishedHolidayLettingsOtherExpenses) + sum(../MTR:CapitalAllowances) - (sum(../MTR:FurnishedHolidayLettingsIncome) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges)))) - (0.00) &gt; -0.001))                 or                (math:abs(((.)) - ((sum(../MTR:FurnishedHolidayLettingsExpenses) + sum(../MTR:FurnishedHolidayLettingsInterestEtcCosts) + sum(../MTR:FurnishedHolidayLettingsManagementEtcFees) + sum(../MTR:FurnishedHolidayLettingsOtherExpenses) + sum(../MTR:CapitalAllowances) - (sum(../MTR:FurnishedHolidayLettingsIncome) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8265</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO16] must equal the sum of [PRO6] + [PRO7] + [PRO8] + [PRO9] + [PRO12] minus ([PRO5] + [PRO10] + [PRO11]) if positive or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [PRO6] + [PRO7] + [PRO8] + [PRO9] + [PRO12] minus ([PRO5] + [PRO10] + [PRO11]) is positive or zero then [PRO16] must equal that sum.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M227" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M227" priority="-1"/>
  <axsl:template match="@*|node()" mode="M227" priority="-2">
    <axsl:apply-templates mode="M227" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p223-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:FurnishedHolidayLettings" mode="M228" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:AdjustedProfitForTheYear or not(((sum(MTR:FurnishedHolidayLettingsIncome) + sum(MTR:PrivateUseAdjustment) + sum(MTR:BalancingCharges) - (sum(MTR:FurnishedHolidayLettingsExpenses) + sum(MTR:FurnishedHolidayLettingsInterestEtcCosts) +  sum(MTR:FurnishedHolidayLettingsManagementEtcFees) + sum(MTR:FurnishedHolidayLettingsOtherExpenses) + sum(MTR:CapitalAllowances))) - (0) &gt;= 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6117</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ([PRO5] + [PRO10] + [PRO11]) minus the sum of ([PRO6] + [PRO7] +  [PRO8] + [PRO9] + [PRO12]) is more than zero. Please complete box [PRO13].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO13] is mandatory if the sum of ([PRO5] + [PRO10] + [PRO11]) minus the sum of ([PRO6] + [PRO7] +  [PRO8] + [PRO9] + [PRO12]) is more than zero.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:AdjustedProfitForTheYear) - sum(MTR:LossesBroughtForward))) - (0) &gt;= 0.001)) or MTR:TaxableProfitForYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8289</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [PRO13] minus [PRO14] ) exceeds 0. Please complete box [PRO15].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO15] should be present if ( [PRO13] minus [PRO14] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(             ((((  sum(MTR:FurnishedHolidayLettingsExpenses)                  + sum(MTR:FurnishedHolidayLettingsInterestEtcCosts)                 + sum(MTR:FurnishedHolidayLettingsManagementEtcFees)                 + sum(MTR:FurnishedHolidayLettingsOtherExpenses)                 + sum(MTR:CapitalAllowances))               -  (  sum(MTR:FurnishedHolidayLettingsIncome)                 + sum(MTR:PrivateUseAdjustment)                 + sum(MTR:BalancingCharges))              )) - (0) &gt;= 0.001))                or              MTR:LossForYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8290</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [PRO6], [PRO7], [PRO8], [PRO9], and [PRO12] ) minus ( [PRO5], [PRO10], and [PRO11] ) ) exceeds 0. Please complete box [PRO16].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO16] should be present if ( ( The sum of [PRO6], [PRO7], [PRO8], [PRO9], and [PRO12] ) minus ( The sum of [PRO5], [PRO10], and [PRO11] ) ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M228" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M228" priority="-1"/>
  <axsl:template match="@*|node()" mode="M228" priority="-2">
    <axsl:apply-templates mode="M228" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p228-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:AnnualInvestmentAllowance" mode="M229" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 750000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6122</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO32] exceeds [£750,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO32] should not exceed [£750,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M229" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M229" priority="-1"/>
  <axsl:template match="@*|node()" mode="M229" priority="-2">
    <axsl:apply-templates mode="M229" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p229-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:TenPercentWearAndTearAllowance" mode="M230" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (0.10 * sum(../../MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) + 1.00) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6123</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO36] exceeds (10% of [PRO20]). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO36] must not exceed (10% of [PRO20]) with a tolerance of £1</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M230" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M230" priority="-1"/>
  <axsl:template match="@*|node()" mode="M230" priority="-2">
    <axsl:apply-templates mode="M230" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p230-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:RentARoomExemptAmount" mode="M231" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../MTR:UKPropertyDetails/MTR:RentARoomReliefClaim)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6468</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [PRO37], box [PRO4] must be absent. Please amend the incorrect entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If present [PRO4] must be absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 4250"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6469</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO37] exceeds [£4,250]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO37] is valid if and only if this does not exceed [£4,250]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M231" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M231" priority="-1"/>
  <axsl:template match="@*|node()" mode="M231" priority="-2">
    <axsl:apply-templates mode="M231" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p231-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear" mode="M232" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - ((                     (sum(../../MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges)                     )                       -                     (sum(../../MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceEtc) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:InterestAndOtherFinancialCharges) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) + sum(../MTR:AnnualInvestmentAllowance) + sum(../MTR:BusinessPremisesRenovationAllowance) + sum(../MTR:EnhancedCapitalAllowances) + sum(../MTR:TenPercentWearAndTearAllowance) + sum(../MTR:RentARoomExemptAmount))                   ))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8269</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO38] must equal ( the sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( the sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [PRO38] is present then it should equal ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M232" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M232" priority="-1"/>
  <axsl:template match="@*|node()" mode="M232" priority="-2">
    <axsl:apply-templates mode="M232" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p232-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:TaxableProfitForTheYear" mode="M233" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForTheYear) - sum(../MTR:LossBroughtForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6472</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO40] must equal( [PRO38] minus [PRO39] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO40] should equal ( [PRO38] minus [PRO39] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M233" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M233" priority="-1"/>
  <axsl:template match="@*|node()" mode="M233" priority="-2">
    <axsl:apply-templates mode="M233" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p233-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:AdjustedLossForTheYear" mode="M234" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (((sum(../../MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceEtc) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:InterestAndOtherFinancialCharges) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) + sum(../MTR:AnnualInvestmentAllowance) + sum(../MTR:BusinessPremisesRenovationAllowance) + sum(../MTR:EnhancedCapitalAllowances) + sum(../MTR:TenPercentWearAndTearAllowance) + sum(../MTR:RentARoomExemptAmount)) - (sum(../../MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) + sum(../../MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8270</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [PRO41] must equal ( ( the sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ) minus ( the sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [PRO41] is present the following should be true: [PRO41] equals ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M234" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M234" priority="-1"/>
  <axsl:template match="@*|node()" mode="M234" priority="-2">
    <axsl:apply-templates mode="M234" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p222-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105" mode="M235" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) + sum(MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) + sum(MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) + sum(MTR:TaxableProfitOrLoss/MTR:PrivateUseAdjustment) + sum(MTR:TaxableProfitOrLoss/MTR:BalancingCharges))               -             (sum(MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceEtc) + sum(MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) + sum(MTR:PropertyIncomeAndExpenses/MTR:InterestAndOtherFinancialCharges) + sum(MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) + sum(MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) + sum(MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) + sum(MTR:TaxableProfitOrLoss/MTR:AnnualInvestmentAllowance) + sum(MTR:TaxableProfitOrLoss/MTR:BusinessPremisesRenovationAllowance) + sum(MTR:TaxableProfitOrLoss/MTR:EnhancedCapitalAllowances) + sum(MTR:TaxableProfitOrLoss/MTR:TenPercentWearAndTearAllowance) + sum(MTR:TaxableProfitOrLoss/MTR:RentARoomExemptAmount)))) - (0) &gt;= 0.001))               or             MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8262</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ) ) exceeds 0. Please complete box [PRO38].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO38] should be present if ( ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ) ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear) - sum(MTR:TaxableProfitOrLoss/MTR:LossBroughtForward))) - (0) &gt;= 0.001)) or MTR:TaxableProfitOrLoss/MTR:TaxableProfitForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6119</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [PRO38] minus [PRO39] ) exceeds 0. Please complete box [PRO40].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>taxable profit for the year should be present if ( [PRO38] minus [PRO39] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((((sum(MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceEtc) + sum(MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) + sum(MTR:PropertyIncomeAndExpenses/MTR:InterestAndOtherFinancialCharges) + sum(MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) + sum(MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) + sum(MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) + sum(MTR:TaxableProfitOrLoss/MTR:AnnualInvestmentAllowance) + sum(MTR:TaxableProfitOrLoss/MTR:BusinessPremisesRenovationAllowance) + sum(MTR:TaxableProfitOrLoss/MTR:EnhancedCapitalAllowances) + sum(MTR:TaxableProfitOrLoss/MTR:TenPercentWearAndTearAllowance) + sum(MTR:TaxableProfitOrLoss/MTR:RentARoomExemptAmount))               -             (sum(MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) + sum(MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) + sum(MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) + sum(MTR:TaxableProfitOrLoss/MTR:PrivateUseAdjustment) + sum(MTR:TaxableProfitOrLoss/MTR:BalancingCharges)))) - (0) &gt;= 0.001))               or             MTR:TaxableProfitOrLoss/MTR:AdjustedLossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8263</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( ( [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ) minus ( [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) ) exceeds 0. Please complete box [PRO41].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[PRO41] should be present if ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO34], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(count(MTR:FurnishedHolidayLettings) = 2) or (count(MTR:FurnishedHolidayLettings/MTR:InEEA) = 1)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8264</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As there are two instances of [PRO5-19], exactly one instance of [PRO18] must be 'yes'. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there are two [PRO5-19], exactly one instance of [PRO18] must be 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M235" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M235" priority="-1"/>
  <axsl:template match="@*|node()" mode="M235" priority="-2">
    <axsl:apply-templates mode="M235" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p236-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:IncomeBeforeTax" mode="M236" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableAmountOnInterestAndOtherSavings"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6133</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR4B]. Please complete box [FOR4F].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR4F] must be present if [FOR4B] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M236" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M236" priority="-1"/>
  <axsl:template match="@*|node()" mode="M236" priority="-2">
    <axsl:apply-templates mode="M236" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p237-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:ForeignTax" mode="M237" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6599</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR4C] exceeds the amount in box [FOR4B]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR4C] should not exceed [FOR4B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M237" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M237" priority="-1"/>
  <axsl:template match="@*|node()" mode="M237" priority="-2">
    <axsl:apply-templates mode="M237" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p238-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:SpecialWithholdingTax" mode="M238" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6700</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR4D] exceeds the amount in box [FOR4B] when [FOR1] is not submitted. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR1] is not 'yes', then [FOR4D] should not exceed [FOR4B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:SWTOrUKTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6134</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR4D]. Please complete box [FOR3].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR3] must be present if [FOR4D] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M238" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M238" priority="-1"/>
  <axsl:template match="@*|node()" mode="M238" priority="-2">
    <axsl:apply-templates mode="M238" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p239-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings" mode="M239" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:TaxableAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6137</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR4F]. Please complete box [FOR4].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR4] must be present if [FOR4F] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M239" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M239" priority="-1"/>
  <axsl:template match="@*|node()" mode="M239" priority="-2">
    <axsl:apply-templates mode="M239" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p235-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource" mode="M240" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(   not(MTR:ClaimToFTCR)    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001) ) or  (    MTR:ClaimToFTCR    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001)  )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6598</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR4F] must equal [FOR4B] if box [FOR4E] completed. If box [FOR4E] not completed,   [FOR4F] must equal [FOR4B] minus [FOR4C]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR4E] is Y, [FOR4F] must = [FOR4B] otherwise [FOR4F] must = [FOR4B] minus [FOR4C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M240" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M240" priority="-1"/>
  <axsl:template match="@*|node()" mode="M240" priority="-2">
    <axsl:apply-templates mode="M240" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p240-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:Totals/MTR:SWTOrUKTax" mode="M241" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6701</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box SpecialWithholdingTax</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M241" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M241" priority="-1"/>
  <axsl:template match="@*|node()" mode="M241" priority="-2">
    <axsl:apply-templates mode="M241" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p241-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:Totals/MTR:TaxableAmount" mode="M242" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6702</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M242" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M242" priority="-1"/>
  <axsl:template match="@*|node()" mode="M242" priority="-2">
    <axsl:apply-templates mode="M242" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p243-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:IncomeBeforeTax" mode="M243" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableAmountOnInterestAndOtherSavings"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6139</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR6B]. Please complete box [FOR6F].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR6F] must be present if [FOR6B] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M243" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M243" priority="-1"/>
  <axsl:template match="@*|node()" mode="M243" priority="-2">
    <axsl:apply-templates mode="M243" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p244-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:ForeignTax" mode="M244" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6141</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR6C] exceeds the amount in box [FOR6B]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR6C] should not exceed [FOR6B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M244" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M244" priority="-1"/>
  <axsl:template match="@*|node()" mode="M244" priority="-2">
    <axsl:apply-templates mode="M244" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p245-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:SpecialWithholdingTax" mode="M245" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6143</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR6D] exceeds the amount in box [FOR6B] when [FOR1] is not submitted. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR1] is not 'yes', then [FOR6D] should not exceed [FOR6B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:SWTOrUKTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6144</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR6D]. Please complete box [FOR5].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR5] must be present if [FOR6D] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M245" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M245" priority="-1"/>
  <axsl:template match="@*|node()" mode="M245" priority="-2">
    <axsl:apply-templates mode="M245" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p246-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings" mode="M246" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:TaxableAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6145</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR6F]. Please complete box [FOR6].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR6] must be present if [FOR6F] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M246" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M246" priority="-1"/>
  <axsl:template match="@*|node()" mode="M246" priority="-2">
    <axsl:apply-templates mode="M246" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p242-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource" mode="M247" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(   not(MTR:ClaimToFTCR)    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001) ) or  (    MTR:ClaimToFTCR    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001)  )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6138</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR6F] must equal [FOR6B] if box [FOR6E] completed. If box [FOR6E] not completed,   [FOR6F] must equal [FOR6B] minus [FOR6C]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR6E] is Y, [FOR6F] must = [FOR6B] otherwise [FOR6F] must = [FOR6B] minus [FOR6C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M247" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M247" priority="-1"/>
  <axsl:template match="@*|node()" mode="M247" priority="-2">
    <axsl:apply-templates mode="M247" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p247-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:Totals/MTR:SWTOrUKTax" mode="M248" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6701</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box SpecialWithholdingTax</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M248" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M248" priority="-1"/>
  <axsl:template match="@*|node()" mode="M248" priority="-2">
    <axsl:apply-templates mode="M248" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p248-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:Totals/MTR:TaxableAmount" mode="M249" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6702</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M249" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M249" priority="-1"/>
  <axsl:template match="@*|node()" mode="M249" priority="-2">
    <axsl:apply-templates mode="M249" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p249-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:AmountInBox6ThatDoesNotQualifyForUKCredit" mode="M250" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:ForeignCompanies/MTR:Totals/MTR:TaxableAmount)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6149</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR7] exceeds the amount in box [FOR6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR7] must not exceed [FOR6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M250" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M250" priority="-1"/>
  <axsl:template match="@*|node()" mode="M250" priority="-2">
    <axsl:apply-templates mode="M250" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p250-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:IncomeBeforeTax" mode="M251" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableAmountOnInterestAndOtherSavings"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6150</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR9B]. Please complete box [FOR9F].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR9F] must be present if [FOR9B] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M251" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M251" priority="-1"/>
  <axsl:template match="@*|node()" mode="M251" priority="-2">
    <axsl:apply-templates mode="M251" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p251-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:ForeignTax" mode="M252" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6151</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR9C] exceeds the amount in box [FOR9B]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR9C] should not exceed [FOR9B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M252" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M252" priority="-1"/>
  <axsl:template match="@*|node()" mode="M252" priority="-2">
    <axsl:apply-templates mode="M252" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p252-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:SpecialWithholdingTax" mode="M253" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6152</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR9D] exceeds the amount in box [FOR9B] when [FOR1] is not submitted. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR1] is not 'yes', then [FOR9D] should not exceed [FOR9B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:SWTOrUKTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6153</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR9D]. Please complete box [FOR8].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR8] must be present if [FOR9D] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M253" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M253" priority="-1"/>
  <axsl:template match="@*|node()" mode="M253" priority="-2">
    <axsl:apply-templates mode="M253" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p253-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings" mode="M254" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:TaxableAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6154</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR9F]. Please complete box [FOR9].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR9] must be present if [FOR9F] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M254" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M254" priority="-1"/>
  <axsl:template match="@*|node()" mode="M254" priority="-2">
    <axsl:apply-templates mode="M254" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p254-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:Totals/MTR:SWTOrUKTax" mode="M255" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6701</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box SpecialWithholdingTax</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M255" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M255" priority="-1"/>
  <axsl:template match="@*|node()" mode="M255" priority="-2">
    <axsl:apply-templates mode="M255" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p255-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:Totals/MTR:TaxableAmount" mode="M256" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6702</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M256" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M256" priority="-1"/>
  <axsl:template match="@*|node()" mode="M256" priority="-2">
    <axsl:apply-templates mode="M256" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p257-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:IncomeBeforeTax" mode="M257" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableAmountOnInterestAndOtherSavings"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6156</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR11B]. Please complete box [FOR11F (psuedo)].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR11F (psuedo)] must be present if [FOR11B] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M257" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M257" priority="-1"/>
  <axsl:template match="@*|node()" mode="M257" priority="-2">
    <axsl:apply-templates mode="M257" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p258-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:ForeignTax" mode="M258" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6157</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR11C] exceeds the amount in box [FOR11B]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR11C] should not exceed [FOR11B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M258" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M258" priority="-1"/>
  <axsl:template match="@*|node()" mode="M258" priority="-2">
    <axsl:apply-templates mode="M258" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p259-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:SpecialWithholdingTax" mode="M259" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6159</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR11D (pseudo)] exceeds the amount in box [FOR11B] when [FOR1] is not submitted. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR1] is not 'yes', then [FOR11D (pseudo)] should not exceed [FOR11B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:SWTOrUKTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6160</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR11D (pseudo)]. Please complete box [FOR10].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR10] must be present if [FOR11D (pseudo)] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M259" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M259" priority="-1"/>
  <axsl:template match="@*|node()" mode="M259" priority="-2">
    <axsl:apply-templates mode="M259" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p260-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings" mode="M260" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:TaxableAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6161</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR11F (psuedo)]. Please complete box [FOR11].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR11] must be present if [FOR11F (psuedo)] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M260" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M260" priority="-1"/>
  <axsl:template match="@*|node()" mode="M260" priority="-2">
    <axsl:apply-templates mode="M260" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p256-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource" mode="M261" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(   not(MTR:ClaimToFTCR)    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001) ) or  (    MTR:ClaimToFTCR    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001)  )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6155</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR11F (psuedo)] must equal [FOR11B] if box [FOR11E] completed. If box [FOR11E] not completed,   [FOR11F (psuedo)] must equal [FOR11B] minus [FOR11C]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR11E] is Y, [FOR11F (psuedo)] must = [FOR11B] otherwise [FOR11F (psuedo)] must = [FOR11B] minus [FOR11C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M261" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M261" priority="-1"/>
  <axsl:template match="@*|node()" mode="M261" priority="-2">
    <axsl:apply-templates mode="M261" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p261-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:Totals/MTR:SWTOrUKTax" mode="M262" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6701</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box SpecialWithholdingTax</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M262" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M262" priority="-1"/>
  <axsl:template match="@*|node()" mode="M262" priority="-2">
    <axsl:apply-templates mode="M262" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p262-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:Totals/MTR:TaxableAmount" mode="M263" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6702</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M263" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M263" priority="-1"/>
  <axsl:template match="@*|node()" mode="M263" priority="-2">
    <axsl:apply-templates mode="M263" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p264-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:IncomeBeforeTax" mode="M264" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TaxableAmountOnInterestAndOtherSavings"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6164</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR13B]. Please complete box [FOR13F (psuedo)].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR13F (psuedo)] must be present if [FOR13B] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M264" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M264" priority="-1"/>
  <axsl:template match="@*|node()" mode="M264" priority="-2">
    <axsl:apply-templates mode="M264" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p265-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:ForeignTax" mode="M265" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6165</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR13C] exceeds the amount in box [FOR13B]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR13C] should not exceed [FOR13B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M265" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M265" priority="-1"/>
  <axsl:template match="@*|node()" mode="M265" priority="-2">
    <axsl:apply-templates mode="M265" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p266-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:SpecialWithholdingTax" mode="M266" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6166</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR13D (psuedo)] exceeds the amount in box [FOR13B] when [FOR1] is not submitted. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR1] is not 'yes', then [FOR13D (psuedo)] should not exceed [FOR13B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:SWTOrUKTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6167</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR13D (psuedo)]. Please complete box [FOR12].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR12] must be present if [FOR13D (psuedo)] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M266" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M266" priority="-1"/>
  <axsl:template match="@*|node()" mode="M266" priority="-2">
    <axsl:apply-templates mode="M266" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p267-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings" mode="M267" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Totals/MTR:TaxableAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6168</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR13F (psuedo)]. Please complete box [FOR13].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR13] must be present if [FOR13F (psuedo)] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M267" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M267" priority="-1"/>
  <axsl:template match="@*|node()" mode="M267" priority="-2">
    <axsl:apply-templates mode="M267" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p263-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource" mode="M268" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(   not(MTR:ClaimToFTCR)    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001) ) or  (    MTR:ClaimToFTCR    and    (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001)  )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6162</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR13F (psuedo)] must equal [FOR13B] if box [FOR13E] completed. If box [FOR13E] not completed,   [FOR13F (psuedo)] must equal [FOR13B] minus [FOR13C]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR13E] is Y, [FOR13F (psuedo)] must = [FOR13B] otherwise [FOR13F (psuedo)] must = [FOR13B] minus [FOR13C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M268" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M268" priority="-1"/>
  <axsl:template match="@*|node()" mode="M268" priority="-2">
    <axsl:apply-templates mode="M268" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p268-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:Totals/MTR:SWTOrUKTax" mode="M269" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6701</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box SpecialWithholdingTax</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M269" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M269" priority="-1"/>
  <axsl:template match="@*|node()" mode="M269" priority="-2">
    <axsl:apply-templates mode="M269" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p269-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:Totals/MTR:TaxableAmount" mode="M270" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6702</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M270" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M270" priority="-1"/>
  <axsl:template match="@*|node()" mode="M270" priority="-2">
    <axsl:apply-templates mode="M270" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p270-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:TotalRentsAndOtherPropertyReceipts" mode="M271" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfProperties"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6586</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [FOR15] must be present if [FOR14] is present. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>number of properties should be present if [FOR14]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M271" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M271" priority="-1"/>
  <axsl:template match="@*|node()" mode="M271" priority="-2">
    <axsl:apply-templates mode="M271" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p271-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:NetProfitOrLoss" mode="M272" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:TotalRentsAndOtherPropertyReceipts) + sum(../MTR:PremiumsPaidForLease)) - sum(../MTR:PropertyExpenses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6703</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR18] must equal ( ( [FOR14] plus [FOR16] ) minus [FOR17] ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR18] should equal ( ( [FOR14] plus [FOR16] ) minus [FOR17] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AdjustedProfitOrLossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8358</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FOR18]. Please complete [FOR24].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR24] should be present if [FOR18] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M272" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M272" priority="-1"/>
  <axsl:template match="@*|node()" mode="M272" priority="-2">
    <axsl:apply-templates mode="M272" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p272-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PrivateUseAdjustment" mode="M273" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:PropertyExpenses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6860</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR19] exceeds the amount in box [FOR17]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR19] should not exceed [FOR17]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AdjustedProfitOrLossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8359</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FOR19]. Please complete [FOR24].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR24] should be present if [FOR19] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M273" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M273" priority="-1"/>
  <axsl:template match="@*|node()" mode="M273" priority="-2">
    <axsl:apply-templates mode="M273" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p273-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:BalancingCharges" mode="M274" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AdjustedProfitOrLossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8360</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FOR20]. Please complete [FOR24]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR24] should be present if [FOR20] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M274" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M274" priority="-1"/>
  <axsl:template match="@*|node()" mode="M274" priority="-2">
    <axsl:apply-templates mode="M274" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p274-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:CapitalAllowances" mode="M275" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AdjustedProfitOrLossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8361</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FOR21]. Please complete [FOR24]. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR24] should be present if [FOR21] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M275" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M275" priority="-1"/>
  <axsl:template match="@*|node()" mode="M275" priority="-2">
    <axsl:apply-templates mode="M275" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p275-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:TenPercentWearAndTearAllowance" mode="M276" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (0.10 * sum(../MTR:TotalRentsAndOtherPropertyReceipts) + 1.00) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6715</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR23] exceeds 10% of box [FOR14]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR23] must not exceed 10% of [FOR14] with a tolerance of £1</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AdjustedProfitOrLossForTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8362</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FOR23]. Please complete [FOR24].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR24] should be present if [FOR23] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M276" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M276" priority="-1"/>
  <axsl:template match="@*|node()" mode="M276" priority="-2">
    <axsl:apply-templates mode="M276" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p276-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:AdjustedProfitOrLossForTheYear" mode="M277" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../MTR:NetProfitOrLoss) + sum(../MTR:PrivateUseAdjustment) + sum(../MTR:BalancingCharges)) - (sum(../MTR:CapitalAllowances) + sum(../MTR:TenPercentWearAndTearAllowance))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6718</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR24] must equal the sum of ( ( [FOR18], [FOR19], and [FOR20] ) minus ( [FOR21] plus [FOR23] ) ). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR24] is valid only if this equals ( ( The sum of [FOR18], [FOR19], and [FOR20] ) minus ( [FOR21] plus [FOR23] ) )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M277" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M277" priority="-1"/>
  <axsl:template match="@*|node()" mode="M277" priority="-2">
    <axsl:apply-templates mode="M277" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p277-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadProfitOrLoss" mode="M278" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) &gt; 0) or ../../MTR:TotalAdjustedProfitOrLoss"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6272</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR30B] exceeds 0. Please complete box [FOR25].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR25] should be present if [FOR30B] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M278" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M278" priority="-1"/>
  <axsl:template match="@*|node()" mode="M278" priority="-2">
    <axsl:apply-templates mode="M278" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p278-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalAdjustedProfitOrLoss" mode="M279" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="math:abs(number(.) - sum( ../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadProfitOrLoss )) &lt;= 1.001"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6719</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box [FOR30B].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box [FOR30B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M279" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M279" priority="-1"/>
  <axsl:template match="@*|node()" mode="M279" priority="-2">
    <axsl:apply-templates mode="M279" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p279-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalTaxableProfit" mode="M280" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="( ((sum(../MTR:TotalAdjustedProfitOrLoss) - sum(../MTR:LossBroughtForward)) - (0) &gt; -0.001) and (math:abs((.) - (sum(../MTR:TotalAdjustedProfitOrLoss) - sum(../MTR:LossBroughtForward))) &lt; 0.001) ) or ( ((sum(../MTR:TotalAdjustedProfitOrLoss) - sum(../MTR:LossBroughtForward)) - (0) &lt;= -0.001) and (math:abs((.) - (0)) &lt; 0.001) )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6507</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR27] must equal [FOR25] minus [FOR26] if this is positive or zero, or [FOR27] must be absent or zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [FOR25] minus [FOR26] is positive or zero then [FOR27] = [FOR25] minus [FOR26] else [FOR27] must be absent or zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M280" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M280" priority="-1"/>
  <axsl:template match="@*|node()" mode="M280" priority="-2">
    <axsl:apply-templates mode="M280" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p280-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalForeignTaxTakenOff" mode="M281" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((number(.)) - (sum( ../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadForeignTax ))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6720</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box [FOR30C].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box [FOR30C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M281" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M281" priority="-1"/>
  <axsl:template match="@*|node()" mode="M281" priority="-2">
    <axsl:apply-templates mode="M281" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p281-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalSpecialWithholdingTax" mode="M282" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((number(.)) - (sum( ../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadSpecialWithholdingTax ))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6721</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Must equal the sum of all occurrences of box [FOR30D].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Total of all iterations of box [FOR30D]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M282" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M282" priority="-1"/>
  <axsl:template match="@*|node()" mode="M282" priority="-2">
    <axsl:apply-templates mode="M282" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p282-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignTaxPaid/MTR:ClaimToFTCRForeignTax" mode="M283" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.)) or ../MTR:ClaimToFTCRAmountChargable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6273</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FORC]. Please complete box [FORF].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FORF] should be present if [FORC]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M283" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M283" priority="-1"/>
  <axsl:template match="@*|node()" mode="M283" priority="-2">
    <axsl:apply-templates mode="M283" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p283-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignTaxPaid/MTR:ClaimToFTCRAmountChargable" mode="M284" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &gt; sum(../MTR:ClaimToFTCRForeignTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6858</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FORF] must exceed [FORC]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FORF] should exceed [FORC]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M284" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M284" priority="-1"/>
  <axsl:template match="@*|node()" mode="M284" priority="-2">
    <axsl:apply-templates mode="M284" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p284-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NumberOfYearsSincePolicyMade" mode="M285" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:ForeignLifeInsuranceGains"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6135</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Number of years entered in box [FOR44] but no gain in box [FOR43]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If number of years since policy made is present the following should be true: [FOR43]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M285" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M285" priority="-1"/>
  <axsl:template match="@*|node()" mode="M285" priority="-2">
    <axsl:apply-templates mode="M285" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p285-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:TaxTreatedAsPaid" mode="M286" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt; sum(../MTR:ForeignLifeInsuranceGains)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6136</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [FOR45] must be less than the amount in box [FOR43]. Please amend the entry.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[FOR45] should be less than [FOR43]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M286" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M286" priority="-1"/>
  <axsl:template match="@*|node()" mode="M286" priority="-2">
    <axsl:apply-templates mode="M286" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p234-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106" mode="M287" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:TotalRentsAndOtherPropertyReceipts or MTR:OverseasLandAndPropertyIncomeDetails/MTR:PremiumsPaidForLease or MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyExpenses) or MTR:OverseasLandAndPropertyIncomeDetails/MTR:NetProfitOrLoss"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6124</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [FOR14] or [FOR16] or [FOR17]. Please complete box [FOR18].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>net profit or loss should be present if [FOR14] or [FOR16] or [FOR17]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((((sum(MTR:TotalAdjustedProfitOrLoss) - sum(MTR:LossBroughtForward))) - (0) &gt;= 0.001)) or MTR:TotalTaxableProfit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6127</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of ( [FOR25] minus [FOR26] ) exceeds 0. Please complete box [FOR27].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total taxable profit should be present if ( [FOR25] minus [FOR26] ) exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadForeignTax) or MTR:TotalForeignTaxTakenOff"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6128</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR30C]. Please complete box [FOR28].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total foreign tax taken off should be present if [FOR30C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadSpecialWithholdingTax) or MTR:TotalSpecialWithholdingTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6130</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [FOR30D]. Please complete box [FOR29].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>total Special Withholding Tax should be present if [FOR30D]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M287" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M287" priority="-1"/>
  <axsl:template match="@*|node()" mode="M287" priority="-2">
    <axsl:apply-templates mode="M287" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p288-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:TotalERGainsInTheYear" mode="M288" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 10000000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8230</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CGT4] exceeds [£10,000,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT4] must not exceed [£10,000,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:TotalGainsInTheYear"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8273</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [CGT4]. Please complete box [CGT3].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [CGT4] is present the following should be true: [CGT3] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:TotalGainsInTheYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8274</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CGT4] exceeds [CGT3]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT4] must not exceed [CGT3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M288" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M288" priority="-1"/>
  <axsl:template match="@*|node()" mode="M288" priority="-2">
    <axsl:apply-templates mode="M288" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p289-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:GainsInvestedUnderSeedEIS" mode="M289" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 100000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8293</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CGT5] exceeds the maximum relief allowable of [£100,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT5] is valid only if this does not exceed [£100,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M289" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M289" priority="-1"/>
  <axsl:template match="@*|node()" mode="M289" priority="-2">
    <axsl:apply-templates mode="M289" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p290-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:UncappedLossesUsedAgainstCurrentYearIncome" mode="M290" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (sum(../MTR:LossesUsedAgainstCurrentYearIncome)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8305</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[CGT13] is valid only if this does not exceed [CGT12].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT13] is valid only if this does not exceed [CGT12].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M290" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M290" priority="-1"/>
  <axsl:template match="@*|node()" mode="M290" priority="-2">
    <axsl:apply-templates mode="M290" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p291-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:UncappedLossesUsedAgainstPreviousYearIncome" mode="M291" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (sum(../MTR:LossesUsedAgainstPreviousYearIncome)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8306</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[CGT15] is valid only if this does not exceed [CGT14].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT15] is valid only if this does not exceed [CGT14].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M291" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M291" priority="-1"/>
  <axsl:template match="@*|node()" mode="M291" priority="-2">
    <axsl:apply-templates mode="M291" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p292-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:IncomeLossesOfTheYearSetAgainstGains" mode="M292" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../MTR:TotalLossesForTheYear) &gt;= (.)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8231</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CGT16] exceeds the amount in box [CGT6]. Please check. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [CGT16] is present the following should be true: [CGT6] is not less than [CGT16]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M292" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M292" priority="-1"/>
  <axsl:template match="@*|node()" mode="M292" priority="-2">
    <axsl:apply-templates mode="M292" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p293-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:AmountOfEntrepreneursReliefClaimedOnDeferredGainsFromBefore23June2010" mode="M293" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 2000000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6170</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in [CGT17] exceeds [£2,000,000]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT17] should not exceed [£2,000,000]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M293" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M293" priority="-1"/>
  <axsl:template match="@*|node()" mode="M293" priority="-2">
    <axsl:apply-templates mode="M293" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p287-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:SummaryOfEnclosedComputations" mode="M294" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(MTR:LossesUsedAgainstEarlierYearsGain) + sum(MTR:LossesUsedAgainstCurrentYearIncome) + sum(MTR:LossesUsedAgainstPreviousYearIncome)) - (sum(MTR:TotalLossesForTheYear)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8229</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of [CGT11] + [CGT12] + [CGT14] must be less than or equal to the amount in box [CGT6]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CGT11] + [CGT12] + [CGT14] must be less than or equal to [CGT6]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M294" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M294" priority="-1"/>
  <axsl:template match="@*|node()" mode="M294" priority="-2">
    <axsl:apply-templates mode="M294" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p294-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:QuotedSharedAndOtherSecurities/MTR:QuotedSharesGainsInTheYear" mode="M295" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:QuotedSharesNumberOfDisposals and ../MTR:QuotedSharesDisposalProceeds"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6397</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [CGT21],  [CGT18] and [CGT19] must be present.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If quoted shares - gains in the year is present the following should be true: [CGT18] and [CGT19]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M295" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M295" priority="-1"/>
  <axsl:template match="@*|node()" mode="M295" priority="-2">
    <axsl:apply-templates mode="M295" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p295-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnquotedSharesAndOtherSecurities/MTR:UnquotedSharesGainsInTheYear" mode="M296" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:UnquotedSharesNumberOfDisposals and ../MTR:UnquotedSharesDisposalProceeds"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6398</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [CGT27], [CGT24] and [CGT25] must be present.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If unquoted shares - gains in the year is present the following should be true: [CGT24] and [CGT25]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M296" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M296" priority="-1"/>
  <axsl:template match="@*|node()" mode="M296" priority="-2">
    <axsl:apply-templates mode="M296" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p296-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:PropertyAndOtherAssetsAndGains/MTR:PropertyEtcAttributedGains" mode="M297" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../../MTR:SummaryOfEnclosedComputations/MTR:TotalGainsInTheYear) &gt;= (.)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8232</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CGT34] exceeds the amount in box [CGT3]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [CGT34] is present the following should be true: [CGT3] is not less than [CGT34]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M297" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M297" priority="-1"/>
  <axsl:template match="@*|node()" mode="M297" priority="-2">
    <axsl:apply-templates mode="M297" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p286-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108" mode="M298" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:QuotedSharedAndOtherSecurities/MTR:QuotedSharesGainsInTheYear or MTR:UnquotedSharesAndOtherSecurities/MTR:UnquotedSharesGainsInTheYear or MTR:PropertyAndOtherAssetsAndGains/MTR:PropertyEtcGainsInTheYear or MTR:PropertyAndOtherAssetsAndGains/MTR:PropertyEtcAttributedGains) or (MTR:SummaryOfEnclosedComputations/MTR:TotalGainsInTheYear)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8271</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [CGT21], or [CGT27], or [CGT33], or [CGT34]. Please complete box [CGT3].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise> If [CGT21] present, or [CGT27] present, or [CGT33] present, or [CGT34] present, then [CGT3] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:SummaryOfEnclosedComputations/MTR:TotalGainsInTheYear) or (math:abs((MTR:SummaryOfEnclosedComputations/MTR:TotalGainsInTheYear) - (sum(MTR:QuotedSharedAndOtherSecurities/MTR:QuotedSharesGainsInTheYear) +  sum(MTR:UnquotedSharesAndOtherSecurities/MTR:UnquotedSharesGainsInTheYear) + sum(MTR:PropertyAndOtherAssetsAndGains/MTR:PropertyEtcGainsInTheYear) + sum(MTR:PropertyAndOtherAssetsAndGains/MTR:PropertyEtcAttributedGains))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8272</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in [CGT3] must be equal to ([CGT21] + [CGT27] + [CGT33] + [CGT34]). Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise> If [CGT3] is present it must be equal to ([CGT21] + [CGT27] + [CGT33] + [CGT34])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:AttachedFiles or MTR:AnyOtherInformationSpace"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6020</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Submission must contain at least one attachment or an entry in the whitespace if Capital Gains Summary is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Submission must contain at least one attachment or an entry in the whitespace if Capital Gains Summary is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(MTR:SummaryOfEnclosedComputations/MTR:TotalERGainsInTheYear) + sum(MTR:SummaryOfEnclosedComputations/MTR:AmountOfEntrepreneursReliefClaimedOnDeferredGainsFromBefore23June2010)) - (0) &lt; 0.001)               or             MTR:QuotedSharedAndOtherSecurities/MTR:QuotedSharesClaimOrElectionMade               or             MTR:UnquotedSharesAndOtherSecurities/MTR:UnquotedSharesClaimOrElectionMade               or             MTR:PropertyAndOtherAssetsAndGains/MTR:PropertyEtcClaimOrElectionMade"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8316</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in ([CGT4] + [CGT17]) is greater than zero. Please fill in [CGT22], or [CGT28], or [CGT35].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If ([CGT4] + [CGT17]) is greater than zero then at least one of [CGT22], or [CGT28] or [CGT35] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M298" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M298" priority="-1"/>
  <axsl:template match="@*|node()" mode="M298" priority="-2">
    <axsl:apply-templates mode="M298" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p298-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK" mode="M299" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:TimeSpentInUK/MTR:NumberOfDaysSpentInUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6876</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD1]. Please complete box [NRD10].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD10]  Must be present if [NRD1] present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M299" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M299" priority="-1"/>
  <axsl:template match="@*|node()" mode="M299" priority="-2">
    <axsl:apply-templates mode="M299" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p299-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:RequestForSplitYearTreatment" mode="M300" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:SplitYearTreatmentDateFromWhichTheUKpartYearBeginsOrEnds"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8317</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[NRD6] must be present if [NRD3] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD6] should be present if [NRD3] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M300" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M300" priority="-1"/>
  <axsl:template match="@*|node()" mode="M300" priority="-2">
    <axsl:apply-templates mode="M300" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p300-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:MoreThanOneCaseOfSplitYearTreatmentApplies" mode="M301" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:RequestForSplitYearTreatment"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8318</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[NRD3] must be present if [NRD3.1] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD3] should be present if [NRD3.1] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M301" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M301" priority="-1"/>
  <axsl:template match="@*|node()" mode="M301" priority="-2">
    <axsl:apply-templates mode="M301" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p301-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:SplitYearTreatmentDateFromWhichTheUKpartYearBeginsOrEnds" mode="M302" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:RequestForSplitYearTreatment"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8319</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[NRD3] must be present if [NRD6] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD3] should be present if [NRD6] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(concat(2015, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))                   and                 (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2016, &quot;-04-05&quot;))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8320</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[NRD6] must be within the current return year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD6] should be within the current return year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M302" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M302" priority="-1"/>
  <axsl:template match="@*|node()" mode="M302" priority="-2">
    <axsl:apply-templates mode="M302" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p302-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:MeetTheThirdAutomaticOverseasTest" mode="M303" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NotResidentInUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8321</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">[NRD1] must be present if [NRD7] is present</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD1] should be present if [NRD7] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M303" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M303" priority="-1"/>
  <axsl:template match="@*|node()" mode="M303" priority="-2">
    <axsl:apply-templates mode="M303" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p303-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:TimeSpentInUK/MTR:NumberOfDaysDueToExceptionalCircumstances" mode="M304" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../MTR:NumberOfDaysSpentInUK)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6723</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [NRD11] exceeds the entry in box [NRD10]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD11] should not exceed [NRD10]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NumberOfDaysSpentInUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6724</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD11], an entry must be present in [NRD10].Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If number of days due to exceptional circumstances is present the following should be true: [NRD10]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M304" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M304" priority="-1"/>
  <axsl:template match="@*|node()" mode="M304" priority="-2">
    <axsl:apply-templates mode="M304" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p304-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:Domicile/MTR:FirstYearOrAlwaysDomiciledOutsideUK" mode="M305" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DomiciledOutsideTheUKForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6386</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD24]. Box [NRD23] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If present [NRD23] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M305" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M305" priority="-1"/>
  <axsl:template match="@*|node()" mode="M305" priority="-2">
    <axsl:apply-templates mode="M305" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p305-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:Domicile/MTR:DateDomicileChanged" mode="M306" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DomiciledOutsideTheUKForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6387</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD25]. Box [NRD23] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If date domicile changed is present the following should be true: [NRD23] present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M306" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M306" priority="-1"/>
  <axsl:template match="@*|node()" mode="M306" priority="-2">
    <axsl:apply-templates mode="M306" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p306-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:Domicile/MTR:BornInUKButNonUKDomicile" mode="M307" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:DateDomicileChanged)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6389</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD26]. [NRD25] must be absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If born in UK but non-UK domicile is present the following should be true: not ( [NRD25] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DomiciledOutsideTheUKForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6388</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD26]. Box [NRD23] must also be completed. Please check.
</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If born in UK but non-UK domicile is present the following should be true: [NRD23] present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M307" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M307" priority="-1"/>
  <axsl:template match="@*|node()" mode="M307" priority="-2">
    <axsl:apply-templates mode="M307" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p307-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:Domicile/MTR:DateOfComingToLiveInUK" mode="M308" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:DomiciledOutsideTheUKForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6390</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD27]. Box [NRD23] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If date of coming to live in UK is present the following should be true: [NRD23] present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:BornInUKButNonUKDomicile)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6726</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD27]. Box [NRD26] must be absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If date of coming to live in UK is present the following should be true: not ( [NRD26] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M308" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M308" priority="-1"/>
  <axsl:template match="@*|node()" mode="M308" priority="-2">
    <axsl:apply-templates mode="M308" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p308-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:RemittanceBasis/MTR:Remittancebasisclaim" mode="M309" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../MTR:Domicile/MTR:DomiciledOutsideTheUKForTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8307</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD28]. Please complete [NRD23].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [NRD28] present, then [NRD23] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(                   (.)                    and (../MTR:UKresidentFor17outOf20years or ../MTR:UKResidentFor12OutOf14Years or ../MTR:UKResidentFor7OutOf9YearsUKResident)                   and not(../MTR:UnremitedIncomeAndGainsUnremittedIncomeAndGainsUnder2000)                   and not(../MTR:LessThan18Years)                 )                 or                   ((sum(../MTR:NominatedCapitalGainsAmount) + sum(../MTR:NominatedIncomeAmount)) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6172</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD28] and either box [NRD30], [NRD31] or [NRD32] and no entry in box [NRD29] or box [NRD33]. Therefore the sum of [NRD34] + [NRD35] must be greater than zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [NRD28] is present and (at least one of [NRD30], [NRD31] or [NRD32] is present) and [NRD29] is absent and [NRD33] is absent then the sum of [NRD34] + [NRD35] must be greater than zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M309" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M309" priority="-1"/>
  <axsl:template match="@*|node()" mode="M309" priority="-2">
    <axsl:apply-templates mode="M309" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p309-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:RemittanceBasis/MTR:UKresidentFor17outOf20years" mode="M310" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Remittancebasisclaim or ../MTR:UnremitedIncomeAndGainsUnremittedIncomeAndGainsUnder2000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8363</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in [NRD30]. Please complete at least one of [NRD28] and [NRD29].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [NRD30] is present then at least one of [NRD28] and [NRD29] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M310" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M310" priority="-1"/>
  <axsl:template match="@*|node()" mode="M310" priority="-2">
    <axsl:apply-templates mode="M310" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p310-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:RemittanceBasis/MTR:UKResidentFor12OutOf14Years" mode="M311" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Remittancebasisclaim or ../MTR:UnremitedIncomeAndGainsUnremittedIncomeAndGainsUnder2000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8292</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD31] box [NRD28] or box  [NRD29] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [NRD31] is present the following should be true: [NRD28] is present or [NRD29] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:UKresidentFor17outOf20years)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8364</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [NRD31] should not be present as there is an entry in [NRD30]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD31] should not be present if [NRD30] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M311" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M311" priority="-1"/>
  <axsl:template match="@*|node()" mode="M311" priority="-2">
    <axsl:apply-templates mode="M311" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p311-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:RemittanceBasis/MTR:UKResidentFor7OutOf9YearsUKResident" mode="M312" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:Remittancebasisclaim or ../MTR:UnremitedIncomeAndGainsUnremittedIncomeAndGainsUnder2000"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8234</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD32]. Please complete [NRD28] or [NRD29].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [NRD32] is present the following should be true: [NRD28] or [NRD29]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:UKresidentFor17outOf20years)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8365</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [NRD32] should not be present as there is an entry in [NRD30]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD32] should not be present if [NRD30] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:UKResidentFor12OutOf14Years)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8366</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The entry in box [NRD32] should not be present as there is an entry in [NRD31]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD32] should not be present if [NRD31] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M312" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M312" priority="-1"/>
  <axsl:template match="@*|node()" mode="M312" priority="-2">
    <axsl:apply-templates mode="M312" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p312-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:RemittanceBasis/MTR:AdjustmentToPaymentsOnAccount" mode="M313" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:UKResidentFor7OutOf9YearsUKResident) or ((.) &lt;= 30000)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8294</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [NRD36] must not exceed [£30,000] if box [NRD32] is present. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD36] must not exceed [£30,000] if [NRD32] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:UKResidentFor12OutOf14Years) or ((.) &lt;= 60000)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8367</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [NRD36] must not exceed [£60,000] if box [NRD31] is present.Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD36] must not exceed [£60,000] if [NRD31] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../MTR:UKresidentFor17outOf20years) or ((.) &lt;= 90000)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8368</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [NRD36] must not exceed [£90,000] if box [NRD30] is present. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[NRD36] must not exceed [£90,000] if [NRD30] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:NominatedCapitalGainsAmount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6174</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD36]. Please complete box [NRD35].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [NRD36] is present, then [NRD35] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M313" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M313" priority="-1"/>
  <axsl:template match="@*|node()" mode="M313" priority="-2">
    <axsl:apply-templates mode="M313" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p297-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109" mode="M314" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:ResidenceStatus/MTR:NotResidentInUK) or MTR:TimeSpentInUK/MTR:NumberOfDaysSpentInUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6876</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [NRD1]. Please complete box [NRD10].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>number of days spent in UK should be present if [NRD1]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M314" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M314" priority="-1"/>
  <axsl:template match="@*|node()" mode="M314" priority="-2">
    <axsl:apply-templates mode="M314" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p313-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SelfAssessment/MTR:StudentLoanRepaymentDue" mode="M315" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:SA100/MTR:StudentLoanRepayments/MTR:IncomeContingentStudentLoanNotification"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6158</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [CAL3] completed including an entry of zero. Box [SLR1] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [CAL3] present including an entry of zero, then [SLR1] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M315" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M315" priority="-1"/>
  <axsl:template match="@*|node()" mode="M315" priority="-2">
    <axsl:apply-templates mode="M315" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p314-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SelfAssessment/MTR:Class4NICsDue" mode="M316" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../MTR:SA103F/MTR:NICs/MTR:Class4NICexception or ../../../MTR:SA103L/MTR:NICs/MTR:Class4NICexception or ../../../MTR:SA104S/MTR:NICs/MTR:Class4NICexception or ../../../MTR:SA104F/MTR:NICs/MTR:Class4NICexception or ../../../MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class4NICexception) or (.) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6595</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in one of boxes [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37]. Box [CAL4] must be zero or absent. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>c) If one of [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] is Y, [CAL4] must be zero or absent ( Error number 310). (see section F)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M316" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M316" priority="-1"/>
  <axsl:template match="@*|node()" mode="M316" priority="-2">
    <axsl:apply-templates mode="M316" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p315-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SelfAssessment/MTR:Class2NICsDue" mode="M317" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= 182.85"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8369</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CAL4.1] exceeds [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CAL4.1] is valid only if this does not exceed [£182.85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M317" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M317" priority="-1"/>
  <axsl:template match="@*|node()" mode="M317" priority="-2">
    <axsl:apply-templates mode="M317" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p316-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:UnderpaidTax/MTR:UnderpaidTaxForYearIncludedInFutureCode" mode="M318" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) &lt;= 9999"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8235</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CAL8] exceeds £9999. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CAL8] must be less than or equal to £9999</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M318" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M318" priority="-1"/>
  <axsl:template match="@*|node()" mode="M318" priority="-2">
    <axsl:apply-templates mode="M318" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p317-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:PaymentsOnAccount/MTR:ClaimToReducePaymentsOnAccount" mode="M319" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../MTR:FirstPaymentOnAccount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6524</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [CAL10] completed. An entry is required in box [CAL11]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>first payment on account should be present if [CAL10] present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M319" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M319" priority="-1"/>
  <axsl:template match="@*|node()" mode="M319" priority="-2">
    <axsl:apply-templates mode="M319" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p318-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:PaymentsOnAccount/MTR:FirstPaymentOnAccount" mode="M320" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(. = 0) or ../MTR:ClaimToReducePaymentsOnAccount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6730</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Entry must not be zero except where a claim to reduce payments on account has been made by ticking box [CAL10] and the claim is to reduce the payments on account to zero. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Entry must not be zero except where a claim to reduce payments on account has been made by ticking box [CAL10] and the claim is to reduce the payments on account to zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M320" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M320" priority="-1"/>
  <axsl:template match="@*|node()" mode="M320" priority="-2">
    <axsl:apply-templates mode="M320" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p319-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SurplusAllowances/MTR:SurplusBlindPersonsAllowance" mode="M321" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) &lt;= 2290"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6243</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CAL12] exceeds Blind Person's allowance for the year. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CAL12] must not exceed [£2,290] for the year.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M321" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M321" priority="-1"/>
  <axsl:template match="@*|node()" mode="M321" priority="-2">
    <axsl:apply-templates mode="M321" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p320-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SurplusAllowances/MTR:SurplusMarriedCouplesAllowance" mode="M322" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) &lt;= 8355"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8236</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount in box [CAL13] exceeds [£8,355] for the year. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CAL13] must not exceed [£8,355] for the year.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M322" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M322" priority="-1"/>
  <axsl:template match="@*|node()" mode="M322" priority="-2">
    <axsl:apply-templates mode="M322" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p321-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:AdjustmentsToTaxDue/MTR:IncreaseInTaxFromAdjustmentToEarlierYears" mode="M323" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:SA101/MTR:BusinessTaxedIncome/MTR:PostCessationOrOtherBusinessReceipts or ../../../MTR:SA103L/MTR:RepaymentOfForeignTaxTaxCreditRelief or ../../../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:ChangeOfAccountingPracticeAdjustment or ../../../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment or ../../../MTR:SA104F/MTR:ShareOfProfits/MTR:AveragingAdjustment or ../../../MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AveragingAdjustment"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6277</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [CAL14]. Please complete [AOI14] or [LUN28] or [FSE71] or [FSE72] or [FPS11] or [SPS11].</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in box [CAL14], box [AOI14] or [LUN28] or [FSE71] or [FSE72] or [FPS11] or [SPS11] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M323" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M323" priority="-1"/>
  <axsl:template match="@*|node()" mode="M323" priority="-2">
    <axsl:apply-templates mode="M323" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p322-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:AdjustmentsToTaxDue/MTR:DecreaseInTaxFromAdjustmentToEarlierYears" mode="M324" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../MTR:SA103F/MTR:Losses/MTR:LossToCarryBack  or  ../../../MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:LossToCarryBack  or  ../../../MTR:SA103L/MTR:AllowableLosses/MTR:LossCarriedBack  or  ../../../MTR:SA104F/MTR:ShareOfLosses/MTR:LossToBeCarriedBack  or  ../../../MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:LossToBeCarriedBack  or  ../../../MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:LossesUsedAgainstEarlierYearsGain  or  ../../../MTR:SA108/MTR:SummaryOfEnclosedComputations/MTR:LossesUsedAgainstPreviousYearIncome  or  (count(../../../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment[. &gt; 0]) &gt; 0) or  (count(../../../MTR:SA104F/MTR:ShareOfProfits/MTR:AveragingAdjustment[. &gt; 0]) &gt; 0) or  (count(../../../MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AveragingAdjustment[. &gt; 0]) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6597</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an amount in box [CAL15], there must be an entry in at least one of boxes [FSE79], [SSE34],[LUN57], [FPS23], [SPS23], [CGT11] or [CGT14] or a positive entry in box [FSE72] or [FPS11] [SPS11]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in box [CAL15] there must be an entry in at least one of boxes [FSE79], [SSE34],[LUN57], [FPS23], [SPS23], [CGT11] or [CGT14] or a positive entry in box [FSE72] or [FPS11] [SPS11]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M324" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M324" priority="-1"/>
  <axsl:template match="@*|node()" mode="M324" priority="-2">
    <axsl:apply-templates mode="M324" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p323-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:AttachedFiles/MTR:Attachment" mode="M325" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="starts-with(text(), 'JVBERi0x')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6790</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The attachment content must be a PDF file.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Attachment content must be a PDF file</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M325" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M325" priority="-1"/>
  <axsl:template match="@*|node()" mode="M325" priority="-2">
    <axsl:apply-templates mode="M325" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p3-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR" mode="M326" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(@AmendedReturn)           or             not(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp)           or             (               date:date(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, 'Z'))) != ''             and               date:seconds(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, 'Z'))) &lt; date:seconds(normalize-space(date:add(normalize-space('2017-01-31T00:00:00Z'),normalize-space('P1Y1D'))))             )           or             (               date:date(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, 'Z'))) = ''             and               date:seconds(normalize-space(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp)) &lt; date:seconds(normalize-space(date:add(normalize-space('2017-01-31T00:00:00Z'),normalize-space('P1Y1D'))))             )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">5090</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You have indicated an amended submission but the amendment window has now closed for the year of assessment to which your submission relates.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Date of receipt of amendment must be less than 12 months following statutory due date</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:SA110/MTR:AdjustmentsToTaxDue/MTR:NextYearsRepaymentClaimedNow) or MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:NextYearsTradingAndCapitalLossesRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6215</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There is an entry in box [CAL16], box [AIL3] must also be completed. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in box [CAL16], box [AIL3] must be present (error 215)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="contains(/hd:GovTalkMessage/hd:Header/hd:MessageDetails/hd:Class, '-ATT') or not(MTR:AttachedFiles)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6001</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Submission must not contain any attachments if the message class indicates no attachments</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Submission must not contain any attachments if the message class indicates no attachments</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(contains(/hd:GovTalkMessage/hd:Header/hd:MessageDetails/hd:Class, '-ATT')) or (MTR:AttachedFiles)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6015</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Submission must contain at least one attachment if the message class indicates attachments</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Submission must contain at least one attachment if the message class indicates attachments</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(count(MTR:SA103F/MTR:NICs/MTR:Class4NICexception) + count(MTR:SA103F/MTR:NICs/MTR:AdjustmentToClass4NICProfits) + count(MTR:SA103L/MTR:NICs/MTR:Class4NICexception) + count(MTR:SA103L/MTR:NICs/MTR:AdjustmentToClass4NICProfits) + count(MTR:SA104F/MTR:NICs/MTR:Class4NICexception) + count(MTR:SA104F/MTR:NICs/MTR:AdjustmentToClass4NICProfits) + count(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class4NICexception) + count(MTR:SA104S/MTR:NICs/MTR:Class4NICexception) + count(MTR:SA104S/MTR:NICs/MTR:AdjustmentToClass4NICProfits))                 &lt;= 1"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6511</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There should only be an entry in one set of Class 4 NIC boxes on the return</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>There should only be an entry in one set of Class 4 NIC boxes on the return</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:PaymentDetails/MTR:BankAccountDetails/MTR:BankOrBuildingSocietyName and MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:NoBankOrBuildingSocietyAccount)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6343</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There should not be entries in both [FIN4] and [FIN9]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>There should not be entries in both [FIN4] and [FIN9].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:TaxTakenOffLumpSumsLeftBlank or ((sum(MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay)) - (sum(MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6038</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box [ASE7] is absent, but the amount in box [EMP2] exceeds the total of boxes [EMP1] + [EMP3]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [ASE7] is absent, [EMP2] must not exceed [EMP1] + [EMP3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(MTR:SA103F/MTR:NICs/MTR:Class4NICexception = 'yes' or MTR:SA103L/MTR:NICs/MTR:Class4NICexception = 'yes' or MTR:SA104S/MTR:NICs/MTR:Class4NICexception = 'yes' or MTR:SA104F/MTR:NICs/MTR:Class4NICexception = 'yes' or MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class4NICexception = 'yes') or not((MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits or MTR:SA103L/MTR:TaxableProfits/MTR:TotalTaxableProfits or MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits or MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits or MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits) and MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth and (translate(date:add(string(MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth), 'P65Y'), '-', '') &lt;= '20150406'))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">6791</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There must be an entry in one of [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] as there is an entry in one of the boxes [FSE76], [LUN52], [SPS20], [FPS20] or [SSE31] and there is an entry in [YPD1], and box [YPD1] date + [65 years] is prior to the beginning of the return year or on 6 April of the return year.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>One of boxes [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] must be set to Y if any of boxes [FSE76], [LUN52], [SPS20], [FPS20] or [SSE31] are present and box [YPD1] is present and box [YPD1] date + [65 years] is prior to the beginning of the return year or on 6 April of the return year.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class2NICamount)             + sum(MTR:SA103F/MTR:NICs/MTR:Class2NICamount)             + sum(MTR:SA103L/MTR:NICs/MTR:Class2NICamount)             + sum(MTR:SA104F/MTR:NICs/MTR:Class2NICamount)             + sum(MTR:SA104S/MTR:NICs/MTR:Class2NICamount)) - (182.85) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8324</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The total of all instances [SSECL2] + [FSECL2] + [FPSCL2] + [SPSCL2]) + [LUNCL2] must be less than or equal to [£182.85]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>(Total all instances [SSECL2] + [FSECL2] + [FPSCL2] + [SPSCL2]) + [LUNCL2] must be less than or equal to [£182.85].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(              count(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:PayClass2NICvoluntarily) &gt; 0            or              count(MTR:SA103F/MTR:NICs/MTR:PayClass2NICvoluntarily) &gt; 0            or              MTR:SA103L/MTR:NICs/MTR:PayClass2NICvoluntarily            or              count(MTR:SA104S/MTR:NICs/MTR:PayClass2NICvoluntarily) &gt; 0            or              count(MTR:SA104F/MTR:NICs/MTR:PayClass2NICvoluntarily) &gt; 0           )         or           ((sum(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits)             + sum(MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits)             + sum(MTR:SA103L/MTR:TaxableProfits/MTR:TotalTaxableProfits)             + sum(MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits)             + sum(MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits)             - (               sum(MTR:SA103F/MTR:NICs/MTR:AdjustmentToClass4NICProfits)               + sum(MTR:SA103L/MTR:NICs/MTR:AdjustmentToClass4NICProfits)               + sum(MTR:SA104S/MTR:NICs/MTR:AdjustmentToClass4NICProfits)               + sum(MTR:SA104F/MTR:NICs/MTR:AdjustmentToClass4NICProfits)             )) - (5965) &lt;= -0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">8374</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">As there is an entry in any of [SSE36], [FSE100], [LUN63], [SPS25] or [FPS25] the sum of all instances [SSE31] + sum of all instances [FSE76] + [LUN52] + sum of all instances [SPS20] + sum of all instances [FPS20] - (sum of all instances [FSE102] + [LUN65] + sum of all instances [SPS27] + sum of all instances [FPS27]) should be less than [£5,965]. Please check.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Where any of [SSE36], [FSE100], [LUN63], [SPS25] or [FPS25] are present then the sum of all instances [SSE31] + sum of all instances [FSE76] + [LUN52] + sum of all instances [SPS20] + sum of all instances [FPS20] - (sum of all instances [FSE102] + [LUN65] + sum of all instances [SPS27] + sum of all instances [FPS27]) should be less than [£5,965]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M326" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M326" priority="-1"/>
  <axsl:template match="@*|node()" mode="M326" priority="-2">
    <axsl:apply-templates mode="M326" select="@*|node()"/>
  </axsl:template>
</axsl:stylesheet>
